/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Filter;
import android.widget.TextView;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.res.ResourceLoader;
import com.xtremelabs.robolectric.shadows.ShadowBaseAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Implements(value=ArrayAdapter.class)
public class ShadowArrayAdapter<T>
extends ShadowBaseAdapter {
    private static final Filter STUB_FILTER = new Filter(){

        protected Filter.FilterResults performFiltering(CharSequence constraint) {
            return null;
        }

        protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
        }
    };
    private Context context;
    private List<T> list;
    private int resource;
    private int textViewResourceId;
    private Filter filter;

    public int getTextViewResourceId() {
        return this.textViewResourceId;
    }

    public int getResourceId() {
        return this.resource;
    }

    public void __constructor__(Context context, int textViewResourceId) {
        this.init(context, textViewResourceId, 0, new ArrayList());
    }

    public void __constructor__(Context context, int resource, int textViewResourceId) {
        this.init(context, resource, textViewResourceId, new ArrayList());
    }

    public void __constructor__(Context context, int textViewResourceId, T[] objects) {
        this.init(context, textViewResourceId, 0, Arrays.asList(objects));
    }

    public void __constructor__(Context context, int resource, int textViewResourceId, T[] objects) {
        this.init(context, resource, textViewResourceId, Arrays.asList(objects));
    }

    public void __constructor__(Context context, int textViewResourceId, List<T> objects) {
        this.init(context, textViewResourceId, 0, objects);
    }

    public void __constructor__(Context context, int resource, int textViewResourceId, List<T> objects) {
        this.init(context, resource, textViewResourceId, objects);
    }

    private void init(Context context, int resource, int textViewResourceId, List<T> objects) {
        this.context = context;
        this.list = objects;
        this.resource = resource;
        this.textViewResourceId = textViewResourceId;
    }

    @Implementation
    public void add(T object) {
        this.list.add(object);
    }

    @Implementation
    public void clear() {
        this.list.clear();
    }

    @Implementation
    public void remove(T object) {
        this.list.remove(object);
    }

    @Implementation
    public void insert(T object, int index) {
        this.list.add(index, object);
    }

    @Implementation
    public Context getContext() {
        return this.context;
    }

    @Implementation
    public int getCount() {
        return this.list.size();
    }

    @Implementation
    public T getItem(int position) {
        return this.list.get(position);
    }

    @Implementation
    public int getPosition(T item) {
        return this.list.indexOf(item);
    }

    @Implementation
    public View getView(int position, View convertView, ViewGroup parent) {
        T item = this.list.get(position);
        View view = convertView == null ? this.getResourceLoader().inflateView(this.context, this.resource, null) : convertView;
        TextView text = this.textViewResourceId == 0 ? (TextView)view : (TextView)view.findViewById(this.textViewResourceId);
        if (item instanceof CharSequence) {
            Robolectric.shadowOf(text).setText((CharSequence)item);
        } else {
            Robolectric.shadowOf(text).setText(item.toString());
        }
        return view;
    }

    @Implementation
    public Filter getFilter() {
        return STUB_FILTER;
    }

    private ResourceLoader getResourceLoader() {
        return Robolectric.shadowOf(Robolectric.application).getResourceLoader();
    }

    @Implementation
    public static ArrayAdapter<CharSequence> createFromResource(Context context, int textArrayResId, int textViewResId) {
        Object[] strings = context.getResources().getTextArray(textArrayResId);
        return new ArrayAdapter(context, textViewResId, strings);
    }
}

