/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.content.res.AssetManager;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.res.ResourceLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

@Implements(value=AssetManager.class)
public final class ShadowAssetManager {
    private ResourceLoader resourceLoader;

    static AssetManager bind(AssetManager assetManager, ResourceLoader resourceLoader) {
        ShadowAssetManager shadowAssetManager = Robolectric.shadowOf(assetManager);
        if (shadowAssetManager.resourceLoader != null) {
            throw new RuntimeException("ResourceLoader already set!");
        }
        shadowAssetManager.resourceLoader = resourceLoader;
        return assetManager;
    }

    @Implementation
    public final String[] list(String path) throws IOException {
        File file = new File(this.resourceLoader.getAssetsBase(), path);
        if (file.isDirectory()) {
            return file.list();
        }
        return new String[0];
    }

    @Implementation
    public final InputStream open(String fileName) throws IOException {
        return new FileInputStream(new File(this.resourceLoader.getAssetsBase(), fileName));
    }
}

