/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.os.AsyncTask;
import android.os.ShadowAsyncTaskBridge;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@Implements(value=AsyncTask.class)
public class ShadowAsyncTask<Params, Progress, Result> {
    @RealObject
    private AsyncTask<Params, Progress, Result> realAsyncTask;
    private final FutureTask<Result> future;
    private final BackgroundWorker worker;
    private AsyncTask.Status status = AsyncTask.Status.PENDING;

    public ShadowAsyncTask() {
        this.worker = new BackgroundWorker();
        this.future = new FutureTask<Result>(this.worker){

            @Override
            protected void done() {
                ShadowAsyncTask.this.status = AsyncTask.Status.FINISHED;
                try {
                    final Object result = this.get();
                    Robolectric.getUiThreadScheduler().post(new Runnable(){

                        @Override
                        public void run() {
                            ShadowAsyncTask.this.getBridge().onPostExecute(result);
                        }
                    });
                }
                catch (CancellationException e) {
                    Robolectric.getUiThreadScheduler().post(new Runnable(){

                        @Override
                        public void run() {
                            ShadowAsyncTask.this.getBridge().onCancelled();
                        }
                    });
                }
                catch (InterruptedException e) {
                }
                catch (Throwable t) {
                    throw new RuntimeException("An error occured while executing doInBackground()", t.getCause());
                }
            }
        };
    }

    @Implementation
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Implementation
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Implementation
    public Result get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Implementation
    public Result get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(timeout, unit);
    }

    @Implementation
    public AsyncTask<Params, Progress, Result> execute(Params ... params) {
        this.status = AsyncTask.Status.RUNNING;
        this.getBridge().onPreExecute();
        this.worker.params = params;
        Robolectric.getBackgroundScheduler().post(new Runnable(){

            @Override
            public void run() {
                ShadowAsyncTask.this.future.run();
            }
        });
        return this.realAsyncTask;
    }

    @Implementation
    public AsyncTask.Status getStatus() {
        return this.status;
    }

    @Implementation
    public void publishProgress(final Progress ... values) {
        Robolectric.getUiThreadScheduler().post(new Runnable(){

            @Override
            public void run() {
                ShadowAsyncTask.this.getBridge().onProgressUpdate(values);
            }
        });
    }

    private ShadowAsyncTaskBridge<Params, Progress, Result> getBridge() {
        return new ShadowAsyncTaskBridge<Params, Progress, Result>(this.realAsyncTask);
    }

    private final class BackgroundWorker
    implements Callable<Result> {
        Params[] params;

        private BackgroundWorker() {
        }

        @Override
        public Result call() throws Exception {
            return ShadowAsyncTask.this.getBridge().doInBackground(this.params);
        }
    }
}

