/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.database.DataSetObserver;
import android.widget.BaseAdapter;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import java.util.ArrayList;
import java.util.List;

@Implements(value=BaseAdapter.class)
public class ShadowBaseAdapter {
    @RealObject
    private BaseAdapter realBaseAdapter;
    private final List<DataSetObserver> dataSetObservers = new ArrayList<DataSetObserver>();

    @Implementation
    public boolean isEmpty() {
        return this.realBaseAdapter.getCount() == 0;
    }

    @Implementation
    public boolean areAllItemsEnabled() {
        return true;
    }

    @Implementation
    public void registerDataSetObserver(DataSetObserver observer) {
        this.dataSetObservers.add(observer);
    }

    @Implementation
    public void unregisterDataSetObserver(DataSetObserver observer) {
        this.dataSetObservers.remove(observer);
    }

    @Implementation
    public void notifyDataSetChanged() {
        for (DataSetObserver dataSetObserver : this.dataSetObservers) {
            dataSetObserver.onChanged();
        }
    }

    @Implementation
    public void notifyDataSetInvalidated() {
        for (DataSetObserver dataSetObserver : this.dataSetObservers) {
            dataSetObserver.onInvalidated();
        }
    }
}

