/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.graphics.Bitmap;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import java.io.IOException;
import java.io.OutputStream;

@Implements(value=Bitmap.class)
public class ShadowBitmap {
    @RealObject
    private Bitmap realBitmap;
    private int width;
    private int height;
    private Bitmap.Config config;
    private boolean mutable;
    private String description = "";
    private int loadedFromResourceId = -1;
    private boolean recycled = false;

    @Implementation
    public boolean compress(Bitmap.CompressFormat format, int quality, OutputStream stream) {
        try {
            stream.write((this.description + " compressed as " + format + " with quality " + quality).getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Implementation
    public static Bitmap createBitmap(int width, int height, Bitmap.Config config) {
        Bitmap scaledBitmap = Robolectric.newInstanceOf(Bitmap.class);
        ShadowBitmap shadowBitmap = Robolectric.shadowOf(scaledBitmap);
        shadowBitmap.appendDescription("Bitmap (" + width + " x " + height + ")");
        shadowBitmap.setWidth(width);
        shadowBitmap.setHeight(height);
        shadowBitmap.setConfig(config);
        return scaledBitmap;
    }

    @Implementation
    public static Bitmap createBitmap(Bitmap bitmap) {
        ShadowBitmap shadowBitmap = Robolectric.shadowOf(bitmap);
        shadowBitmap.appendDescription(" created from Bitmap object");
        return bitmap;
    }

    @Implementation
    public static Bitmap createScaledBitmap(Bitmap src, int dstWidth, int dstHeight, boolean filter) {
        Bitmap scaledBitmap = Robolectric.newInstanceOf(Bitmap.class);
        ShadowBitmap shadowBitmap = Robolectric.shadowOf(scaledBitmap);
        shadowBitmap.appendDescription(Robolectric.shadowOf(src).getDescription());
        shadowBitmap.appendDescription(" scaled to " + dstWidth + " x " + dstHeight);
        if (filter) {
            shadowBitmap.appendDescription(" with filter " + filter);
        }
        shadowBitmap.setWidth(dstWidth);
        shadowBitmap.setHeight(dstHeight);
        return scaledBitmap;
    }

    @Implementation
    public void recycle() {
        this.recycled = true;
    }

    @Implementation
    public final boolean isRecycled() {
        return this.recycled;
    }

    @Implementation
    public Bitmap copy(Bitmap.Config config, boolean isMutable) {
        ShadowBitmap shadowBitmap = Robolectric.shadowOf(this.realBitmap);
        shadowBitmap.setConfig(config);
        shadowBitmap.setMutable(isMutable);
        return this.realBitmap;
    }

    @Implementation
    public final Bitmap.Config getConfig() {
        return this.config;
    }

    public void setConfig(Bitmap.Config config) {
        this.config = config;
    }

    @Implementation
    public final boolean isMutable() {
        return this.mutable;
    }

    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    public void appendDescription(String s) {
        this.description = this.description + s;
    }

    public void setDescription(String s) {
        this.description = s;
    }

    public String getDescription() {
        return this.description;
    }

    public static Bitmap create(String name) {
        Bitmap bitmap = Robolectric.newInstanceOf(Bitmap.class);
        Robolectric.shadowOf(bitmap).appendDescription(name);
        return bitmap;
    }

    public void setLoadedFromResourceId(int loadedFromResourceId) {
        this.loadedFromResourceId = loadedFromResourceId;
    }

    public int getLoadedFromResourceId() {
        if (this.loadedFromResourceId == -1) {
            throw new IllegalStateException("not loaded from a resource");
        }
        return this.loadedFromResourceId;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Implementation
    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Implementation
    public int getHeight() {
        return this.height;
    }

    @Implementation
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != ShadowBitmap.class) {
            return false;
        }
        ShadowBitmap that = Robolectric.shadowOf((Bitmap)o);
        if (this.height != that.height) {
            return false;
        }
        if (this.width != that.width) {
            return false;
        }
        return !(this.description != null ? !this.description.equals(that.description) : that.description != null);
    }

    @Implementation
    public int hashCode() {
        int result = this.width;
        result = 31 * result + this.height;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    @Implementation
    public String toString() {
        return "ShadowBitmap{description='" + this.description + '\'' + ", width=" + this.width + ", height=" + this.height + '}';
    }

    public Bitmap getRealBitmap() {
        return this.realBitmap;
    }
}

