/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import com.xtremelabs.robolectric.shadows.ShadowDrawable;

@Implements(value=BitmapDrawable.class)
public class ShadowBitmapDrawable
extends ShadowDrawable {
    private Bitmap bitmap;
    private ColorFilter colorFilter;
    private String drawableCreateFromStreamSource;
    private String drawableCreateFromPath;
    @RealObject
    private BitmapDrawable realBitmapDrawable;
    private Shader.TileMode tileModeX;
    private Shader.TileMode tileModeY;

    public void __constructor__(Bitmap bitmap) {
        this.bitmap = bitmap;
    }

    @Implementation
    public void draw(Canvas canvas) {
        Paint paint = new Paint();
        paint.setColorFilter(this.colorFilter);
        canvas.drawBitmap(this.realBitmapDrawable.getBitmap(), 0.0f, 0.0f, paint);
    }

    @Implementation
    public void setColorFilter(ColorFilter colorFilter) {
        this.colorFilter = colorFilter;
    }

    @Implementation
    public Bitmap getBitmap() {
        return this.bitmap;
    }

    @Override
    public int getLoadedFromResourceId() {
        return Robolectric.shadowOf(this.bitmap).getLoadedFromResourceId();
    }

    public void setSource(String drawableCreateFromStreamSource) {
        this.drawableCreateFromStreamSource = drawableCreateFromStreamSource;
    }

    public String getSource() {
        return this.drawableCreateFromStreamSource;
    }

    public void setPath(String drawableCreateFromPath) {
        this.drawableCreateFromPath = drawableCreateFromPath;
    }

    public String getPath() {
        return this.drawableCreateFromPath;
    }

    @Implementation
    public void setTileModeX(Shader.TileMode mode) {
        this.tileModeX = mode;
    }

    @Implementation
    public Shader.TileMode getTileModeX() {
        return this.tileModeX;
    }

    @Implementation
    public void setTileModeY(Shader.TileMode mode) {
        this.tileModeY = mode;
    }

    @Implementation
    public Shader.TileMode getTileModeY() {
        return this.tileModeY;
    }

    @Implementation
    public void setTileModeXY(Shader.TileMode modeX, Shader.TileMode modeY) {
        this.setTileModeX(modeX);
        this.setTileModeY(modeY);
    }

    @Override
    @Implementation
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != ShadowBitmapDrawable.class) {
            return false;
        }
        ShadowBitmapDrawable that = Robolectric.shadowOf((BitmapDrawable)o);
        if (this.bitmap != null ? !this.bitmap.equals(that.bitmap) : that.bitmap != null) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Implementation
    public int hashCode() {
        return this.bitmap != null ? this.bitmap.hashCode() : 0;
    }

    @Implementation
    public String toString() {
        return "ShadowBitmapDrawable{bitmap=" + this.bitmap + '}';
    }
}

