/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.Rect;
import android.net.Uri;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.shadows.ShadowBitmap;
import com.xtremelabs.robolectric.util.Join;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@Implements(value=BitmapFactory.class)
public class ShadowBitmapFactory {
    private static Map<String, Point> widthAndHeightMap = new HashMap<String, Point>();

    @Implementation
    public static Bitmap decodeResource(Resources res, int id) {
        Bitmap bitmap = ShadowBitmapFactory.create("resource:" + ShadowBitmapFactory.getResourceName(id));
        Robolectric.shadowOf(bitmap).setLoadedFromResourceId(id);
        return bitmap;
    }

    private static String getResourceName(int id) {
        return Robolectric.shadowOf(Robolectric.application).getResourceLoader().getNameForId(id);
    }

    @Implementation
    public static Bitmap decodeFile(String pathName) {
        return ShadowBitmapFactory.create("file:" + pathName);
    }

    @Implementation
    public static Bitmap decodeFile(String pathName, BitmapFactory.Options options) {
        return ShadowBitmapFactory.create("file:" + pathName, options);
    }

    @Implementation
    public static Bitmap decodeStream(InputStream is) {
        return ShadowBitmapFactory.decodeStream(is, null, new BitmapFactory.Options());
    }

    @Implementation
    public static Bitmap decodeStream(InputStream is, Rect outPadding, BitmapFactory.Options opts) {
        return ShadowBitmapFactory.create(is.toString().replaceFirst("stream for ", ""), opts);
    }

    static Bitmap create(String name) {
        return ShadowBitmapFactory.create(name, new BitmapFactory.Options());
    }

    public static Bitmap create(String name, BitmapFactory.Options options) {
        Point widthAndHeight;
        Bitmap bitmap = Robolectric.newInstanceOf(Bitmap.class);
        ShadowBitmap shadowBitmap = Robolectric.shadowOf(bitmap);
        shadowBitmap.appendDescription("Bitmap for " + name);
        String optionsString = ShadowBitmapFactory.stringify(options);
        if (optionsString.length() > 0) {
            shadowBitmap.appendDescription(" with options ");
            shadowBitmap.appendDescription(optionsString);
        }
        if ((widthAndHeight = widthAndHeightMap.get(name)) == null) {
            widthAndHeight = new Point(100, 100);
        }
        shadowBitmap.setWidth(widthAndHeight.x);
        shadowBitmap.setHeight(widthAndHeight.y);
        options.outWidth = widthAndHeight.x;
        options.outHeight = widthAndHeight.y;
        return bitmap;
    }

    public static void provideWidthAndHeightHints(Uri uri, int width, int height) {
        widthAndHeightMap.put(uri.toString(), new Point(width, height));
    }

    public static void provideWidthAndHeightHints(int resourceId, int width, int height) {
        widthAndHeightMap.put("resource:" + ShadowBitmapFactory.getResourceName(resourceId), new Point(width, height));
    }

    public static void provideWidthAndHeightHints(String file, int width, int height) {
        widthAndHeightMap.put("file:" + file, new Point(width, height));
    }

    private static String stringify(BitmapFactory.Options options) {
        ArrayList<String> opts = new ArrayList<String>();
        if (options.inJustDecodeBounds) {
            opts.add("inJustDecodeBounds");
        }
        if (options.inSampleSize > 1) {
            opts.add("inSampleSize=" + options.inSampleSize);
        }
        return Join.join(", ", opts);
    }

    public static void reset() {
        widthAndHeightMap.clear();
    }
}

