/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.hardware.Camera;
import android.view.SurfaceHolder;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import java.util.HashMap;
import java.util.Map;

@Implements(value=Camera.class)
public class ShadowCamera {
    private boolean locked;
    private boolean previewing;
    private boolean released;
    private Camera.Parameters parameters;
    private Camera.PreviewCallback previewCallback;
    private SurfaceHolder surfaceHolder;
    private static Map<Integer, Camera.CameraInfo> cameras = new HashMap<Integer, Camera.CameraInfo>();
    @RealObject
    private Camera realCamera;

    public void __constructor__() {
        this.locked = true;
        this.previewing = false;
        this.released = false;
    }

    @Implementation
    public static Camera open() {
        return Robolectric.newInstanceOf(Camera.class);
    }

    @Implementation
    public void unlock() {
        this.locked = false;
    }

    @Implementation
    public void reconnect() {
        this.locked = true;
    }

    @Implementation
    public Camera.Parameters getParameters() {
        if (null == this.parameters) {
            this.parameters = Robolectric.newInstanceOf(Camera.Parameters.class);
        }
        return this.parameters;
    }

    @Implementation
    public void setParameters(Camera.Parameters params) {
        this.parameters = params;
    }

    @Implementation
    public void setPreviewDisplay(SurfaceHolder holder) {
        this.surfaceHolder = holder;
    }

    @Implementation
    public void startPreview() {
        this.previewing = true;
    }

    @Implementation
    public void stopPreview() {
        this.previewing = false;
    }

    @Implementation
    public void release() {
        this.released = true;
    }

    @Implementation
    public void setPreviewCallback(Camera.PreviewCallback cb) {
        this.previewCallback = cb;
    }

    @Implementation
    public void setOneShotPreviewCallback(Camera.PreviewCallback cb) {
        this.previewCallback = cb;
    }

    @Implementation
    public void setPreviewCallbackWithBuffer(Camera.PreviewCallback cb) {
        this.previewCallback = cb;
    }

    @Implementation
    public static void getCameraInfo(int cameraId, Camera.CameraInfo cameraInfo) {
        Camera.CameraInfo foundCam = cameras.get(cameraId);
        cameraInfo.facing = foundCam.facing;
        cameraInfo.orientation = foundCam.orientation;
    }

    @Implementation
    public static int getNumberOfCameras() {
        return cameras.size();
    }

    public void invokePreviewCallback(byte[] data) {
        if (this.previewCallback != null) {
            this.previewCallback.onPreviewFrame(data, this.realCamera);
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isPreviewing() {
        return this.previewing;
    }

    public boolean isReleased() {
        return this.released;
    }

    public SurfaceHolder getPreviewDisplay() {
        return this.surfaceHolder;
    }

    public static void addCameraInfo(int id, Camera.CameraInfo camInfo) {
        cameras.put(id, camInfo);
    }

    public static void clearCameraInfo() {
        cameras.clear();
    }
}

