/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.hardware.Camera;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import java.util.ArrayList;
import java.util.List;

@Implements(value=Camera.Parameters.class)
public class ShadowCameraParameters {
    private int pictureWidth = 1280;
    private int pictureHeight = 960;
    private int previewWidth = 640;
    private int previewHeight = 480;
    private int previewFormat = 17;
    private int previewFpsMin = 10;
    private int previewFpsMax = 30;
    private int previewFps = 30;

    @Implementation
    public Camera.Size getPictureSize() {
        Camera camera = Robolectric.newInstanceOf(Camera.class);
        camera.getClass();
        Camera.Size pictureSize = new Camera.Size(camera, 0, 0);
        pictureSize.width = this.pictureWidth;
        pictureSize.height = this.pictureHeight;
        return pictureSize;
    }

    @Implementation
    public int getPreviewFormat() {
        return this.previewFormat;
    }

    @Implementation
    public void getPreviewFpsRange(int[] range) {
        range[0] = this.previewFpsMin;
        range[1] = this.previewFpsMax;
    }

    @Implementation
    public int getPreviewFrameRate() {
        return this.previewFps;
    }

    @Implementation
    public Camera.Size getPreviewSize() {
        Camera camera = Robolectric.newInstanceOf(Camera.class);
        camera.getClass();
        Camera.Size previewSize = new Camera.Size(camera, 0, 0);
        previewSize.width = this.previewWidth;
        previewSize.height = this.previewHeight;
        return previewSize;
    }

    @Implementation
    public List<Camera.Size> getSupportedPictureSizes() {
        ArrayList<Camera.Size> supportedSizes = new ArrayList<Camera.Size>();
        this.addSize(supportedSizes, 320, 240);
        this.addSize(supportedSizes, 640, 480);
        this.addSize(supportedSizes, 800, 600);
        return supportedSizes;
    }

    @Implementation
    public List<Integer> getSupportedPictureFormats() {
        ArrayList<Integer> formats = new ArrayList<Integer>();
        formats.add(17);
        formats.add(256);
        return formats;
    }

    @Implementation
    public List<Integer> getSupportedPreviewFormats() {
        ArrayList<Integer> formats = new ArrayList<Integer>();
        formats.add(17);
        formats.add(256);
        return formats;
    }

    @Implementation
    public List<int[]> getSupportedPreviewFpsRange() {
        ArrayList<int[]> supportedRanges = new ArrayList<int[]>();
        this.addRange(supportedRanges, 15000, 15000);
        this.addRange(supportedRanges, 10000, 30000);
        return supportedRanges;
    }

    @Implementation
    public List<Integer> getSupportedPreviewFrameRates() {
        ArrayList<Integer> supportedRates = new ArrayList<Integer>();
        supportedRates.add(10);
        supportedRates.add(15);
        supportedRates.add(30);
        return supportedRates;
    }

    @Implementation
    public List<Camera.Size> getSupportedPreviewSizes() {
        ArrayList<Camera.Size> supportedSizes = new ArrayList<Camera.Size>();
        this.addSize(supportedSizes, 320, 240);
        this.addSize(supportedSizes, 640, 480);
        return supportedSizes;
    }

    @Implementation
    public void setPictureSize(int width, int height) {
        this.pictureWidth = width;
        this.pictureHeight = height;
    }

    @Implementation
    public void setPreviewFormat(int pixel_format) {
        this.previewFormat = pixel_format;
    }

    @Implementation
    public void setPreviewFpsRange(int min, int max) {
        this.previewFpsMin = min;
        this.previewFpsMax = max;
    }

    @Implementation
    public void setPreviewFrameRate(int fps) {
        this.previewFps = fps;
    }

    @Implementation
    public void setPreviewSize(int width, int height) {
        this.previewWidth = width;
        this.previewHeight = height;
    }

    public int getPreviewWidth() {
        return this.previewWidth;
    }

    public int getPreviewHeight() {
        return this.previewHeight;
    }

    public int getPictureWidth() {
        return this.pictureWidth;
    }

    public int getPictureHeight() {
        return this.pictureHeight;
    }

    private void addSize(List<Camera.Size> sizes, int width, int height) {
        Camera camera = Robolectric.newInstanceOf(Camera.class);
        camera.getClass();
        Camera.Size newSize = new Camera.Size(camera, 0, 0);
        newSize.width = width;
        newSize.height = height;
        sizes.add(newSize);
    }

    private void addRange(List<int[]> ranges, int min, int max) {
        int[] range = new int[]{min, max};
        ranges.add(range);
    }
}

