/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import java.util.ArrayList;
import java.util.List;

@Implements(value=Canvas.class)
public class ShadowCanvas {
    private List<PathPaintHistoryEvent> pathPaintEvents = new ArrayList<PathPaintHistoryEvent>();
    private List<CirclePaintHistoryEvent> circlePaintEvents = new ArrayList<CirclePaintHistoryEvent>();
    private Paint drawnPaint;
    private Bitmap targetBitmap = Robolectric.newInstanceOf(Bitmap.class);
    private float translateX;
    private float translateY;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;

    public void __constructor__(Bitmap bitmap) {
        this.targetBitmap = bitmap;
    }

    public void appendDescription(String s) {
        Robolectric.shadowOf(this.targetBitmap).appendDescription(s);
    }

    public String getDescription() {
        return Robolectric.shadowOf(this.targetBitmap).getDescription();
    }

    @Implementation
    public void translate(float x, float y) {
        this.translateX = x;
        this.translateY = y;
    }

    @Implementation
    public void scale(float sx, float sy) {
        this.scaleX = sx;
        this.scaleY = sy;
    }

    @Implementation
    public void scale(float sx, float sy, float px, float py) {
        this.scaleX = sx;
        this.scaleY = sy;
    }

    @Implementation
    public void drawPaint(Paint paint) {
        this.drawnPaint = paint;
    }

    @Implementation
    public void drawColor(int color) {
        this.appendDescription("draw color " + color);
    }

    @Implementation
    public void drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
        this.describeBitmap(bitmap, paint);
        int x = (int)(left + this.translateX);
        int y = (int)(top + this.translateY);
        if (x != 0 && y != 0) {
            this.appendDescription(" at (" + x + "," + y + ")");
        }
        if (this.scaleX != 1.0f && this.scaleY != 1.0f) {
            this.appendDescription(" scaled by (" + this.scaleX + "," + this.scaleY + ")");
        }
    }

    @Implementation
    public void drawPath(Path path, Paint paint) {
        this.pathPaintEvents.add(new PathPaintHistoryEvent(path, paint));
        this.separateLines();
        this.appendDescription("Path " + Robolectric.shadowOf(path).getPoints().toString());
    }

    private void describeBitmap(Bitmap bitmap, Paint paint) {
        ColorFilter colorFilter;
        this.separateLines();
        this.appendDescription(Robolectric.shadowOf(bitmap).getDescription());
        if (paint != null && (colorFilter = paint.getColorFilter()) != null) {
            this.appendDescription(" with " + colorFilter);
        }
    }

    private void separateLines() {
        if (this.getDescription().length() != 0) {
            this.appendDescription("\n");
        }
    }

    @Implementation
    public void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        this.describeBitmap(bitmap, paint);
        this.appendDescription(" transformed by matrix");
    }

    public int getPathPaintHistoryCount() {
        return this.pathPaintEvents.size();
    }

    public int getCirclePaintHistoryCount() {
        return this.circlePaintEvents.size();
    }

    public boolean hasDrawnPath() {
        return this.getPathPaintHistoryCount() > 0;
    }

    public boolean hasDrawnCircle() {
        return this.circlePaintEvents.size() > 0;
    }

    public Paint getDrawnPathPaint(int i) {
        return this.pathPaintEvents.get(i).pathPaint;
    }

    public Path getDrawnPath(int i) {
        return this.pathPaintEvents.get(i).drawnPath;
    }

    public CirclePaintHistoryEvent getDrawnCircle(int i) {
        return this.circlePaintEvents.get(i);
    }

    public void resetCanvasHistory() {
        this.pathPaintEvents.clear();
        this.circlePaintEvents.clear();
    }

    public Paint getDrawnPaint() {
        return this.drawnPaint;
    }

    public static class CirclePaintHistoryEvent {
        public Paint paint;
        public float centerX;
        public float centerY;
        public float radius;

        private CirclePaintHistoryEvent(float centerX, float centerY, float radius, Paint paint) {
            this.paint = paint;
            this.centerX = centerX;
            this.centerY = centerY;
            this.radius = radius;
        }
    }

    private static class PathPaintHistoryEvent {
        private Path drawnPath;
        private Paint pathPaint;

        PathPaintHistoryEvent(Path drawnPath, Paint pathPaint) {
            this.drawnPath = drawnPath;
            this.pathPaint = pathPaint;
        }
    }
}

