/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.graphics.ColorMatrix;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.util.Join;
import java.util.ArrayList;

@Implements(value=ColorMatrix.class)
public class ShadowColorMatrix {
    private float[] src;

    public void __constructor__(float[] src) {
        this.src = src;
    }

    public void __constructor__() {
        this.reset();
    }

    public void __constructor__(ColorMatrix src) {
        this.src = Robolectric.shadowOf((ColorMatrix)src).src;
    }

    @Implementation
    public void reset() {
        this.src = new float[20];
        this.src[18] = 1.0f;
        this.src[12] = 1.0f;
        this.src[6] = 1.0f;
        this.src[0] = 1.0f;
    }

    @Implementation
    public void setSaturation(float sat) {
        this.reset();
        float[] m = this.src;
        float invSat = 1.0f - sat;
        float R2 = 0.213f * invSat;
        float G = 0.715f * invSat;
        float B = 0.072f * invSat;
        m[0] = R2 + sat;
        m[1] = G;
        m[2] = B;
        m[5] = R2;
        m[6] = G + sat;
        m[7] = B;
        m[10] = R2;
        m[11] = G;
        m[12] = B + sat;
    }

    @Implementation
    public String toString() {
        ArrayList<String> floats = new ArrayList<String>();
        for (float f : this.src) {
            String format = String.format("%.2f", Float.valueOf(f));
            format = format.replace(".00", "");
            floats.add(format);
        }
        return Join.join(",", floats);
    }
}

