/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.content.ComponentName;
import android.content.Context;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;

@Implements(value=ComponentName.class)
public class ShadowComponentName {
    private String pkg;
    private String cls;

    public void __constructor__(String pkg, String cls) {
        if (pkg == null) {
            throw new NullPointerException("package name is null");
        }
        if (cls == null) {
            throw new NullPointerException("class name is null");
        }
        this.pkg = pkg;
        this.cls = cls;
    }

    public void __constructor__(Context pkg, String cls) {
        if (cls == null) {
            throw new NullPointerException("class name is null");
        }
        this.pkg = pkg.getPackageName();
        this.cls = cls;
    }

    public void __constructor__(Context pkg, Class<?> cls) {
        this.pkg = pkg.getPackageName();
        this.cls = cls.getName();
    }

    @Implementation
    public String getPackageName() {
        return this.pkg;
    }

    @Implementation
    public String getClassName() {
        return this.cls;
    }

    @Implementation
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if ((o = Robolectric.shadowOf_(o)) == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ShadowComponentName that = (ShadowComponentName)o;
        if (this.cls != null ? !this.cls.equals(that.cls) : that.cls != null) {
            return false;
        }
        return !(this.pkg != null ? !this.pkg.equals(that.pkg) : that.pkg != null);
    }

    @Implementation
    public int hashCode() {
        int result = this.pkg != null ? this.pkg.hashCode() : 0;
        result = 31 * result + (this.cls != null ? this.cls.hashCode() : 0);
        return result;
    }

    @Implementation
    public String toString() {
        return "ComponentName{pkg='" + this.pkg + '\'' + ", cls='" + this.cls + '\'' + '}';
    }
}

