/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.content.ContentValues;
import android.util.Log;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@Implements(value=ContentValues.class)
public final class ShadowContentValues {
    private static final String TAG = "ShadowContentValues";
    private HashMap<String, Object> values = new HashMap();

    public void __constructor__(ContentValues from) {
        this.values = new HashMap<String, Object>(Robolectric.shadowOf((ContentValues)from).values);
    }

    @Implementation
    public void put(String key, String value) {
        this.values.put(key, value);
    }

    @Implementation
    public void putAll(ContentValues other) {
        this.values.putAll(Robolectric.shadowOf((ContentValues)other).values);
    }

    @Implementation
    public void put(String key, Byte value) {
        this.values.put(key, value);
    }

    @Implementation
    public void put(String key, Short value) {
        this.values.put(key, value);
    }

    @Implementation
    public void put(String key, Integer value) {
        this.values.put(key, value);
    }

    @Implementation
    public void put(String key, Long value) {
        this.values.put(key, value);
    }

    @Implementation
    public void put(String key, Float value) {
        this.values.put(key, value);
    }

    @Implementation
    public void put(String key, Double value) {
        this.values.put(key, value);
    }

    @Implementation
    public void put(String key, Boolean value) {
        this.values.put(key, value);
    }

    @Implementation
    public void put(String key, byte[] value) {
        this.values.put(key, value);
    }

    @Implementation
    public void putNull(String key) {
        this.values.put(key, null);
    }

    @Implementation
    public int size() {
        return this.values.size();
    }

    @Implementation
    public void remove(String key) {
        this.values.remove(key);
    }

    @Implementation
    public void clear() {
        this.values.clear();
    }

    @Implementation
    public boolean containsKey(String key) {
        return this.values.containsKey(key);
    }

    @Implementation
    public Object get(String key) {
        return this.values.get(key);
    }

    @Implementation
    public String getAsString(String key) {
        Object value = this.values.get(key);
        return value != null ? value.toString() : null;
    }

    @Implementation
    public Long getAsLong(String key) {
        Object value = this.values.get(key);
        try {
            return value != null ? Long.valueOf(((Number)value).longValue()) : null;
        }
        catch (ClassCastException e) {
            if (value instanceof CharSequence) {
                try {
                    return Long.valueOf(value.toString());
                }
                catch (NumberFormatException e2) {
                    Log.e((String)TAG, (String)("Cannot parse Long value for " + value + " at key " + key));
                    return null;
                }
            }
            Log.e((String)TAG, (String)("Cannot cast value for " + key + " to a Long: " + value), (Throwable)e);
            return null;
        }
    }

    @Implementation
    public Integer getAsInteger(String key) {
        Object value = this.values.get(key);
        try {
            return value != null ? Integer.valueOf(((Number)value).intValue()) : null;
        }
        catch (ClassCastException e) {
            if (value instanceof CharSequence) {
                try {
                    return Integer.valueOf(value.toString());
                }
                catch (NumberFormatException e2) {
                    Log.e((String)TAG, (String)("Cannot parse Integer value for " + value + " at key " + key));
                    return null;
                }
            }
            Log.e((String)TAG, (String)("Cannot cast value for " + key + " to a Integer: " + value), (Throwable)e);
            return null;
        }
    }

    @Implementation
    public Short getAsShort(String key) {
        Object value = this.values.get(key);
        try {
            return value != null ? Short.valueOf(((Number)value).shortValue()) : null;
        }
        catch (ClassCastException e) {
            if (value instanceof CharSequence) {
                try {
                    return Short.valueOf(value.toString());
                }
                catch (NumberFormatException e2) {
                    Log.e((String)TAG, (String)("Cannot parse Short value for " + value + " at key " + key));
                    return null;
                }
            }
            Log.e((String)TAG, (String)("Cannot cast value for " + key + " to a Short: " + value), (Throwable)e);
            return null;
        }
    }

    @Implementation
    public Byte getAsByte(String key) {
        Object value = this.values.get(key);
        try {
            return value != null ? Byte.valueOf(((Number)value).byteValue()) : null;
        }
        catch (ClassCastException e) {
            if (value instanceof CharSequence) {
                try {
                    return Byte.valueOf(value.toString());
                }
                catch (NumberFormatException e2) {
                    Log.e((String)TAG, (String)("Cannot parse Byte value for " + value + " at key " + key));
                    return null;
                }
            }
            Log.e((String)TAG, (String)("Cannot cast value for " + key + " to a Byte: " + value), (Throwable)e);
            return null;
        }
    }

    @Implementation
    public Double getAsDouble(String key) {
        Object value = this.values.get(key);
        try {
            return value != null ? Double.valueOf(((Number)value).doubleValue()) : null;
        }
        catch (ClassCastException e) {
            if (value instanceof CharSequence) {
                try {
                    return Double.valueOf(value.toString());
                }
                catch (NumberFormatException e2) {
                    Log.e((String)TAG, (String)("Cannot parse Double value for " + value + " at key " + key));
                    return null;
                }
            }
            Log.e((String)TAG, (String)("Cannot cast value for " + key + " to a Double: " + value), (Throwable)e);
            return null;
        }
    }

    @Implementation
    public Float getAsFloat(String key) {
        Object value = this.values.get(key);
        try {
            return value != null ? Float.valueOf(((Number)value).floatValue()) : null;
        }
        catch (ClassCastException e) {
            if (value instanceof CharSequence) {
                try {
                    return Float.valueOf(value.toString());
                }
                catch (NumberFormatException e2) {
                    Log.e((String)TAG, (String)("Cannot parse Float value for " + value + " at key " + key));
                    return null;
                }
            }
            Log.e((String)TAG, (String)("Cannot cast value for " + key + " to a Float: " + value), (Throwable)e);
            return null;
        }
    }

    @Implementation
    public Boolean getAsBoolean(String key) {
        Object value = this.values.get(key);
        try {
            return (Boolean)value;
        }
        catch (ClassCastException e) {
            if (value instanceof CharSequence) {
                return Boolean.valueOf(value.toString());
            }
            Log.e((String)TAG, (String)("Cannot cast value for " + key + " to a Boolean: " + value), (Throwable)e);
            return null;
        }
    }

    @Implementation
    public byte[] getAsByteArray(String key) {
        Object value = this.values.get(key);
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        return null;
    }

    @Implementation
    public Set<Map.Entry<String, Object>> valueSet() {
        return this.values.entrySet();
    }

    @Implementation
    public int describeContents() {
        return 0;
    }

    @Implementation
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        Object o = Robolectric.shadowOf_(object);
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (!(o instanceof ContentValues)) {
            return false;
        }
        return this.values.equals(Robolectric.shadowOf((ContentValues)((ContentValues)o)).values);
    }

    @Implementation
    public int hashCode() {
        return this.values.hashCode();
    }

    @Implementation
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String name : this.values.keySet()) {
            String value = this.getAsString(name);
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(name + "=" + value);
        }
        return sb.toString();
    }
}

