/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.app.Application;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import com.xtremelabs.robolectric.res.ResourceLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;

@Implements(value=Context.class)
public abstract class ShadowContext {
    public static final File CACHE_DIR = new File(System.getProperty("java.io.tmpdir"), "android-cache");
    public static final File EXTERNAL_CACHE_DIR = new File(System.getProperty("java.io.tmpdir"), "android-external-cache");
    public static final File FILES_DIR = new File(System.getProperty("java.io.tmpdir"), "android-tmp");
    public static final File EXTERNAL_FILES_DIR = new File(System.getProperty("java.io.tmpdir"), "android-external-files");
    @RealObject
    private Context realContext;

    @Implementation
    public String getString(int resId) {
        return this.realContext.getResources().getString(resId);
    }

    @Implementation
    public CharSequence getText(int resId) {
        return this.realContext.getResources().getText(resId);
    }

    @Implementation
    public String getString(int resId, Object ... formatArgs) {
        return this.realContext.getResources().getString(resId, formatArgs);
    }

    @Implementation
    public abstract Resources.Theme getTheme();

    @Implementation
    public final TypedArray obtainStyledAttributes(int[] attrs) {
        return this.getTheme().obtainStyledAttributes(attrs);
    }

    @Implementation
    public final TypedArray obtainStyledAttributes(int resid, int[] attrs) throws Resources.NotFoundException {
        return this.getTheme().obtainStyledAttributes(resid, attrs);
    }

    @Implementation
    public final TypedArray obtainStyledAttributes(AttributeSet set, int[] attrs) {
        return this.getTheme().obtainStyledAttributes(set, attrs, 0, 0);
    }

    @Implementation
    public final TypedArray obtainStyledAttributes(AttributeSet set, int[] attrs, int defStyleAttr, int defStyleRes) {
        return this.getTheme().obtainStyledAttributes(set, attrs, defStyleAttr, defStyleRes);
    }

    @Implementation
    public File getCacheDir() {
        CACHE_DIR.mkdirs();
        return CACHE_DIR;
    }

    @Implementation
    public File getFilesDir() {
        FILES_DIR.mkdirs();
        return FILES_DIR;
    }

    @Implementation
    public File getExternalCacheDir() {
        EXTERNAL_CACHE_DIR.mkdir();
        return EXTERNAL_CACHE_DIR;
    }

    @Implementation
    public File getExternalFilesDir(String type) {
        File f = type == null ? EXTERNAL_FILES_DIR : new File(EXTERNAL_FILES_DIR, type);
        f.mkdirs();
        return f;
    }

    @Implementation
    public FileInputStream openFileInput(String path) throws FileNotFoundException {
        return new FileInputStream(this.getFileStreamPath(path));
    }

    @Implementation
    public FileOutputStream openFileOutput(String path, int mode) throws FileNotFoundException {
        return new FileOutputStream(this.getFileStreamPath(path));
    }

    @Implementation
    public File getFileStreamPath(String name) {
        if (name.contains(File.separator)) {
            throw new IllegalArgumentException("File " + name + " contains a path separator");
        }
        return new File(this.getFilesDir(), name);
    }

    @Implementation
    public boolean deleteFile(String name) {
        return this.getFileStreamPath(name).delete();
    }

    public ResourceLoader getResourceLoader() {
        return Robolectric.shadowOf((Application)this.realContext.getApplicationContext()).getResourceLoader();
    }

    public static void clearFilesAndCache() {
        ShadowContext.clearFiles(FILES_DIR);
        ShadowContext.clearFiles(CACHE_DIR);
        ShadowContext.clearFiles(EXTERNAL_CACHE_DIR);
        ShadowContext.clearFiles(EXTERNAL_FILES_DIR);
    }

    public static void clearFiles(File dir) {
        File[] files;
        if (dir != null && dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    ShadowContext.clearFiles(f);
                }
                f.delete();
            }
        }
    }
}

