/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Looper;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import com.xtremelabs.robolectric.shadows.ShadowApplication;
import com.xtremelabs.robolectric.shadows.ShadowContext;
import com.xtremelabs.robolectric.tester.android.content.TestSharedPreferences;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Implements(value=ContextWrapper.class)
public class ShadowContextWrapper
extends ShadowContext {
    @RealObject
    private ContextWrapper realContextWrapper;
    protected Context baseContext;
    private PackageManager packageManager;
    private String appName;
    private String packageName;
    private Set<String> grantedPermissions = new HashSet<String>();

    public void __constructor__(Context baseContext) {
        this.baseContext = baseContext;
    }

    @Implementation
    public Context getApplicationContext() {
        return this.baseContext.getApplicationContext();
    }

    @Override
    @Implementation
    public Resources.Theme getTheme() {
        return this.getResources().newTheme();
    }

    @Implementation
    public Resources getResources() {
        return this.getApplicationContext().getResources();
    }

    @Implementation
    public ContentResolver getContentResolver() {
        return this.getApplicationContext().getContentResolver();
    }

    @Implementation
    public Object getSystemService(String name) {
        return this.getApplicationContext().getSystemService(name);
    }

    @Implementation
    public void sendBroadcast(Intent intent) {
        this.getApplicationContext().sendBroadcast(intent);
    }

    public List<Intent> getBroadcastIntents() {
        return ((ShadowApplication)Robolectric.shadowOf(this.getApplicationContext())).getBroadcastIntents();
    }

    @Implementation
    public int checkPermission(String permission, int pid, int uid) {
        return this.grantedPermissions.contains(permission) ? 0 : -1;
    }

    @Implementation
    public Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        return ((ShadowApplication)Robolectric.shadowOf(this.getApplicationContext())).registerReceiverWithContext(receiver, filter, (Context)this.realContextWrapper);
    }

    @Implementation
    public void unregisterReceiver(BroadcastReceiver broadcastReceiver) {
        this.getApplicationContext().unregisterReceiver(broadcastReceiver);
    }

    @Implementation
    public String getPackageName() {
        return this.realContextWrapper == this.getApplicationContext() ? this.packageName : this.getApplicationContext().getPackageName();
    }

    @Implementation
    public ApplicationInfo getApplicationInfo() {
        ApplicationInfo appInfo = new ApplicationInfo();
        appInfo.name = this.appName;
        appInfo.packageName = this.packageName;
        appInfo.processName = this.packageName;
        return appInfo;
    }

    public void setApplicationName(String name) {
        this.appName = name;
    }

    @Implementation
    public PackageManager getPackageManager() {
        return this.realContextWrapper == this.getApplicationContext() ? this.packageManager : this.getApplicationContext().getPackageManager();
    }

    @Implementation
    public ComponentName startService(Intent service) {
        return this.getApplicationContext().startService(service);
    }

    @Implementation
    public boolean stopService(Intent name) {
        return this.getApplicationContext().stopService(name);
    }

    @Implementation
    public void startActivity(Intent intent) {
        this.getApplicationContext().startActivity(intent);
    }

    @Implementation
    public SharedPreferences getSharedPreferences(String name, int mode) {
        return new TestSharedPreferences(this.getShadowApplication().getSharedPreferenceMap(), name, mode);
    }

    @Implementation
    public AssetManager getAssets() {
        return this.getResources().getAssets();
    }

    public Intent getNextStartedActivity() {
        return this.getShadowApplication().getNextStartedActivity();
    }

    public Intent peekNextStartedActivity() {
        return this.getShadowApplication().peekNextStartedActivity();
    }

    public Intent getNextStartedService() {
        return this.getShadowApplication().getNextStartedService();
    }

    public void clearStartedServices() {
        this.getShadowApplication().clearStartedServices();
    }

    public Intent peekNextStartedService() {
        return this.getShadowApplication().peekNextStartedService();
    }

    public Intent getNextStoppedService() {
        return this.getShadowApplication().getNextStoppedService();
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageManager(PackageManager packageManager) {
        this.packageManager = packageManager;
    }

    @Implementation
    public Looper getMainLooper() {
        return this.getShadowApplication().getMainLooper();
    }

    @Implementation
    public Context getBaseContext() {
        return this.baseContext;
    }

    @Implementation
    public void attachBaseContext(Context context) {
        this.baseContext = context;
    }

    private ShadowApplication getShadowApplication() {
        return (ShadowApplication)Robolectric.shadowOf(this.getApplicationContext());
    }

    @Implementation
    public boolean bindService(Intent intent, ServiceConnection serviceConnection, int i) {
        return this.getShadowApplication().bindService(intent, serviceConnection, i);
    }

    public void grantPermissions(String ... permissionNames) {
        for (String permissionName : permissionNames) {
            this.grantedPermissions.add(permissionName);
        }
    }
}

