/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.os.CountDownTimer;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;

@Implements(value=CountDownTimer.class)
public class ShadowCountDownTimer {
    private boolean started;
    private long countDownInterval;
    private long millisInFuture;
    @RealObject
    CountDownTimer countDownTimer;

    public void __constructor__(long millisInFuture, long countDownInterval) {
        this.countDownInterval = countDownInterval;
        this.millisInFuture = millisInFuture;
        this.started = false;
    }

    @Implementation
    public final synchronized CountDownTimer start() {
        this.started = true;
        return this.countDownTimer;
    }

    @Implementation
    public final void cancel() {
        this.started = false;
    }

    public void invokeTick(long millisUntilFinished) {
        this.countDownTimer.onTick(millisUntilFinished);
    }

    public void invokeFinish() {
        this.countDownTimer.onFinish();
    }

    public boolean hasStarted() {
        return this.started;
    }

    public long getCountDownInterval() {
        return this.countDownInterval;
    }

    public long getMillisInFuture() {
        return this.millisInFuture;
    }
}

