/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CursorAdapter;
import android.widget.FilterQueryProvider;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.shadows.ShadowBaseAdapter;
import java.util.ArrayList;
import java.util.List;

@Implements(value=CursorAdapter.class)
public class ShadowCursorAdapter
extends ShadowBaseAdapter {
    private List<View> views = new ArrayList<View>();
    protected boolean mDataValid;
    protected boolean mAutoRequery;
    protected Cursor mCursor;
    protected Context mContext;
    protected int mRowIDColumn;
    protected ChangeObserver mChangeObserver;
    protected DataSetObserver mDataSetObserver = new MyDataSetObserver();
    protected FilterQueryProvider mFilterQueryProvider;

    @Implementation
    public View getView(int position, View convertView, ViewGroup parent) {
        if (this.mCursor == null || this.views.size() == 0) {
            return null;
        }
        if (convertView != null) {
            return convertView;
        }
        return this.views.get(position);
    }

    public void setViews(List<View> views) {
        this.views = views;
    }

    public void __constructor__(Context context, Cursor c) {
        this.initialize(context, c, true);
    }

    public void __constructor__(Context context, Cursor c, boolean autoRequery) {
        this.initialize(context, c, autoRequery);
    }

    private void initialize(Context context, Cursor c, boolean autoRequery) {
        boolean cursorPresent = c != null;
        this.mAutoRequery = autoRequery;
        this.mCursor = c;
        this.mDataValid = cursorPresent;
        this.mContext = context;
        this.mRowIDColumn = cursorPresent ? c.getColumnIndexOrThrow("_id") : -1;
        this.mChangeObserver = new ChangeObserver();
        if (cursorPresent) {
            c.registerContentObserver((ContentObserver)this.mChangeObserver);
            c.registerDataSetObserver(this.mDataSetObserver);
        }
    }

    @Implementation
    public Cursor getCursor() {
        return this.mCursor;
    }

    @Implementation
    public int getCount() {
        if (this.mDataValid && this.mCursor != null) {
            return this.mCursor.getCount();
        }
        return 0;
    }

    @Implementation
    public Object getItem(int position) {
        if (this.mDataValid && this.mCursor != null) {
            this.mCursor.moveToPosition(position);
            return this.mCursor;
        }
        return null;
    }

    @Implementation
    public long getItemId(int position) {
        if (this.mDataValid && this.mCursor != null) {
            this.mCursor.getColumnIndexOrThrow("_id");
            if (this.mCursor.moveToPosition(position)) {
                return this.mCursor.getLong(this.mRowIDColumn);
            }
            return 0L;
        }
        return 0L;
    }

    @Implementation
    public boolean hasStableIds() {
        return true;
    }

    @Implementation
    public void changeCursor(Cursor cursor) {
        if (cursor == this.mCursor) {
            return;
        }
        if (this.mCursor != null) {
            this.mCursor.unregisterContentObserver((ContentObserver)this.mChangeObserver);
            this.mCursor.unregisterDataSetObserver(this.mDataSetObserver);
            this.mCursor.close();
        }
        this.mCursor = cursor;
        if (cursor != null) {
            cursor.registerContentObserver((ContentObserver)this.mChangeObserver);
            cursor.registerDataSetObserver(this.mDataSetObserver);
            this.mRowIDColumn = cursor.getColumnIndexOrThrow("_id");
            this.mDataValid = true;
            this.notifyDataSetChanged();
        } else {
            this.mRowIDColumn = -1;
            this.mDataValid = false;
            this.notifyDataSetInvalidated();
        }
    }

    @Implementation
    public CharSequence convertToString(Cursor cursor) {
        return cursor == null ? "" : cursor.toString();
    }

    @Implementation
    public Cursor runQueryOnBackgroundThread(CharSequence constraint) {
        if (this.mFilterQueryProvider != null) {
            return this.mFilterQueryProvider.runQuery(constraint);
        }
        return this.mCursor;
    }

    @Implementation
    public FilterQueryProvider getFilterQueryProvider() {
        return this.mFilterQueryProvider;
    }

    @Implementation
    public void setFilterQueryProvider(FilterQueryProvider filterQueryProvider) {
        this.mFilterQueryProvider = filterQueryProvider;
    }

    protected void onContentChangedInternal() {
        if (this.mAutoRequery && this.mCursor != null && !this.mCursor.isClosed()) {
            this.mDataValid = this.mCursor.requery();
        }
    }

    private class MyDataSetObserver
    extends DataSetObserver {
        private MyDataSetObserver() {
        }

        public void onChanged() {
            ShadowCursorAdapter.this.mDataValid = true;
            ShadowCursorAdapter.this.notifyDataSetChanged();
        }

        public void onInvalidated() {
            ShadowCursorAdapter.this.mDataValid = false;
            ShadowCursorAdapter.this.notifyDataSetInvalidated();
        }
    }

    private class ChangeObserver
    extends ContentObserver {
        public ChangeObserver() {
            super(new Handler());
        }

        public boolean deliverSelfNotifications() {
            return true;
        }

        public void onChange(boolean selfChange) {
            ShadowCursorAdapter.this.onContentChangedInternal();
        }
    }
}

