/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import com.xtremelabs.robolectric.shadows.ShadowLayoutInflater;
import com.xtremelabs.robolectric.tester.android.view.TestWindow;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

@Implements(value=Dialog.class)
public class ShadowDialog {
    @RealObject
    private Dialog realDialog;
    private boolean isShowing;
    Context context;
    private int layoutId;
    private int themeId;
    private View inflatedView;
    private boolean hasBeenDismissed;
    private DialogInterface.OnDismissListener onDismissListener;
    protected CharSequence title;
    private DialogInterface.OnCancelListener onCancelListener;
    private Window window;
    private Activity ownerActivity;
    private boolean isCancelable = true;
    private boolean hasShownBefore;
    private static final ArrayList<Dialog> shownDialogs = new ArrayList();

    public static void reset() {
        ShadowDialog.setLatestDialog(null);
        shownDialogs.clear();
    }

    public static Dialog getLatestDialog() {
        ShadowDialog dialog = Robolectric.getShadowApplication().getLatestDialog();
        return dialog == null ? null : dialog.realDialog;
    }

    public static void setLatestDialog(ShadowDialog latestDialog) {
        Robolectric.getShadowApplication().setLatestDialog(latestDialog);
    }

    public void __constructor__(Context context) {
        this.__constructor__(context, -1);
    }

    public void __constructor__(Context context, int themeId) {
        this.context = context;
        this.themeId = themeId;
    }

    @Implementation
    public void setContentView(int layoutResID) {
        this.layoutId = layoutResID;
    }

    @Implementation
    public void setContentView(View view) {
        this.inflatedView = view;
    }

    @Implementation
    public void setTitle(int stringResourceId) {
        this.title = this.context.getResources().getText(stringResourceId);
    }

    @Implementation(i18nSafe=false)
    public void setTitle(CharSequence title) {
        this.title = title;
    }

    @Implementation
    public void setOwnerActivity(Activity activity) {
        this.ownerActivity = activity;
    }

    @Implementation
    public Activity getOwnerActivity() {
        return this.ownerActivity;
    }

    @Implementation
    public Context getContext() {
        return this.context;
    }

    @Implementation
    public void onBackPressed() {
        this.cancel();
    }

    @Implementation
    public void show() {
        ShadowDialog.setLatestDialog(this);
        shownDialogs.add(this.realDialog);
        this.isShowing = true;
        try {
            if (!this.hasShownBefore) {
                Method onCreateMethod = Dialog.class.getDeclaredMethod("onCreate", Bundle.class);
                onCreateMethod.setAccessible(true);
                onCreateMethod.invoke((Object)this.realDialog, new Object[]{null});
            }
            Method onStartMethod = Dialog.class.getDeclaredMethod("onStart", new Class[0]);
            onStartMethod.setAccessible(true);
            onStartMethod.invoke((Object)this.realDialog, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.hasShownBefore = true;
    }

    @Implementation
    public void hide() {
        this.isShowing = false;
    }

    @Implementation
    public boolean isShowing() {
        return this.isShowing;
    }

    @Implementation
    public void dismiss() {
        this.isShowing = false;
        this.hasBeenDismissed = true;
        if (this.onDismissListener != null) {
            this.onDismissListener.onDismiss((DialogInterface)this.realDialog);
        }
    }

    @Implementation
    public View findViewById(int viewId) {
        if (this.inflatedView != null) {
            return this.inflatedView.findViewById(viewId);
        }
        if (this.layoutId > 0 && this.context != null) {
            this.inflatedView = ShadowLayoutInflater.from(this.context).inflate(this.layoutId, null);
            return this.inflatedView.findViewById(viewId);
        }
        return null;
    }

    public void clickOn(int viewId) {
        this.findViewById(viewId).performClick();
    }

    @Implementation
    public void setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.onDismissListener = onDismissListener;
    }

    @Implementation
    public void setCancelable(boolean flag) {
        this.isCancelable = flag;
    }

    public boolean isCancelable() {
        return this.isCancelable;
    }

    @Implementation
    public void cancel() {
        if (this.onCancelListener != null) {
            this.onCancelListener.onCancel((DialogInterface)this.realDialog);
        }
        this.realDialog.dismiss();
    }

    @Implementation
    public void setOnCancelListener(DialogInterface.OnCancelListener listener) {
        this.onCancelListener = listener;
    }

    public DialogInterface.OnCancelListener getOnCancelListener() {
        return this.onCancelListener;
    }

    @Implementation
    public Window getWindow() {
        if (this.window == null) {
            this.window = new TestWindow(this.realDialog.getContext());
        }
        return this.window;
    }

    @Implementation
    public LayoutInflater getLayoutInflater() {
        return LayoutInflater.from((Context)this.realDialog.getContext());
    }

    public int getLayoutId() {
        return this.layoutId;
    }

    public int getThemeId() {
        return this.themeId;
    }

    public boolean hasBeenDismissed() {
        return this.hasBeenDismissed;
    }

    public CharSequence getTitle() {
        return this.title;
    }

    public void clickOnText(int textId) {
        String text;
        if (this.inflatedView == null) {
            this.inflatedView = ShadowLayoutInflater.from(this.context).inflate(this.layoutId, null);
        }
        if (!this.clickOnText(this.inflatedView, text = this.getContext().getResources().getString(textId))) {
            throw new IllegalArgumentException("Text not found: " + text);
        }
    }

    private boolean clickOnText(View view, String text) {
        if (text.equals(Robolectric.shadowOf(view).innerText())) {
            view.performClick();
            return true;
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                View child = viewGroup.getChildAt(i);
                if (!this.clickOnText(child, text)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Dialog> getShownDialogs() {
        return shownDialogs;
    }
}

