/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import java.io.InputStream;
import java.util.ArrayList;

@Implements(value=Drawable.class)
public class ShadowDrawable {
    private static int defaultIntrinsicWidth = -1;
    private static int defaultIntrinsicHeight = -1;
    static ArrayList<String> corruptStreamSources = new ArrayList();
    @RealObject
    Drawable realObject;
    private Rect bounds = new Rect(0, 0, 0, 0);
    private int intrinsicWidth = defaultIntrinsicWidth;
    private int intrinsicHeight = defaultIntrinsicHeight;
    private int alpha;
    private InputStream inputStream;
    private int level;
    private int loadedFromResourceId = -1;

    @Implementation
    public static Drawable createFromStream(InputStream is, String srcName) {
        if (corruptStreamSources.contains(srcName)) {
            return null;
        }
        BitmapDrawable drawable = new BitmapDrawable(Robolectric.newInstanceOf(Bitmap.class));
        Robolectric.shadowOf(drawable).setSource(srcName);
        Robolectric.shadowOf(drawable).setInputStream(is);
        return drawable;
    }

    @Implementation
    public static Drawable createFromPath(String pathName) {
        BitmapDrawable drawable = new BitmapDrawable(Robolectric.newInstanceOf(Bitmap.class));
        Robolectric.shadowOf(drawable).setPath(pathName);
        return drawable;
    }

    public static Drawable createFromResourceId(int resourceId) {
        Bitmap bitmap = Robolectric.newInstanceOf(Bitmap.class);
        Robolectric.shadowOf(bitmap).setLoadedFromResourceId(resourceId);
        BitmapDrawable drawable = new BitmapDrawable(bitmap);
        return drawable;
    }

    @Implementation
    public final Rect getBounds() {
        return this.bounds;
    }

    @Implementation
    public void setBounds(Rect rect) {
        this.bounds = rect;
    }

    @Implementation
    public void setBounds(int left, int top, int right, int bottom) {
        this.bounds = new Rect(left, top, right, bottom);
    }

    @Implementation
    public Rect copyBounds() {
        Rect bounds = new Rect();
        this.copyBounds(bounds);
        return bounds;
    }

    @Implementation
    public void copyBounds(Rect bounds) {
        bounds.set(this.getBounds());
    }

    @Implementation
    public int getIntrinsicWidth() {
        return this.intrinsicWidth;
    }

    @Implementation
    public int getIntrinsicHeight() {
        return this.intrinsicHeight;
    }

    public static void addCorruptStreamSource(String src) {
        corruptStreamSources.add(src);
    }

    public static void setDefaultIntrinsicWidth(int defaultIntrinsicWidth) {
        ShadowDrawable.defaultIntrinsicWidth = defaultIntrinsicWidth;
    }

    public static void setDefaultIntrinsicHeight(int defaultIntrinsicHeight) {
        ShadowDrawable.defaultIntrinsicHeight = defaultIntrinsicHeight;
    }

    public void setIntrinsicWidth(int intrinsicWidth) {
        this.intrinsicWidth = intrinsicWidth;
    }

    public void setIntrinsicHeight(int intrinsicHeight) {
        this.intrinsicHeight = intrinsicHeight;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Implementation
    public int getLevel() {
        return this.level;
    }

    @Implementation
    public boolean setLevel(int level) {
        this.level = level;
        return false;
    }

    @Implementation
    public boolean equals(Object o) {
        if (this.realObject == o) {
            return true;
        }
        if (o == null || this.realObject.getClass() != o.getClass()) {
            return false;
        }
        ShadowDrawable that = Robolectric.shadowOf((Drawable)o);
        if (this.intrinsicHeight != that.intrinsicHeight) {
            return false;
        }
        if (this.intrinsicWidth != that.intrinsicWidth) {
            return false;
        }
        return !(this.bounds != null ? !this.bounds.equals((Object)that.bounds) : that.bounds != null);
    }

    @Implementation
    public int hashCode() {
        int result = this.bounds != null ? this.bounds.hashCode() : 0;
        result = 31 * result + this.intrinsicWidth;
        result = 31 * result + this.intrinsicHeight;
        return result;
    }

    @Implementation
    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public static void reset() {
        corruptStreamSources.clear();
    }

    public int getLoadedFromResourceId() {
        return this.loadedFromResourceId;
    }

    public void setLoadedFromResourceId(int resourceId) {
        this.loadedFromResourceId = resourceId;
    }
}

