/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.widget.EditText;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.shadows.ShadowTextView;

@Implements(value=EditText.class)
public class ShadowEditText
extends ShadowTextView {
    private int maxLength = Integer.MAX_VALUE;

    public ShadowEditText() {
        this.focusable = true;
        this.focusableInTouchMode = true;
    }

    @Override
    public void applyAttributes() {
        super.applyAttributes();
        this.maxLength = this.attributeSet.getAttributeIntValue("android", "maxLength", Integer.MAX_VALUE);
    }

    @Override
    @Implementation(i18nSafe=true)
    public void setText(CharSequence str) {
        if (!TextUtils.isEmpty((CharSequence)str) && str.length() > this.maxLength) {
            str = str.subSequence(0, this.maxLength);
        }
        super.setText(str);
    }

    @Implementation
    public Editable getText() {
        CharSequence text = super.getText();
        if (!(text instanceof Editable)) {
            return new SpannableStringBuilder(text);
        }
        return (Editable)text;
    }

    @Override
    @Implementation
    public void setSelection(int index) {
        super.setSelection(index);
    }

    @Override
    @Implementation
    public void setSelection(int start, int end) {
        super.setSelection(start, end);
    }
}

