/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import com.xtremelabs.robolectric.shadows.SerializedFragmentState;
import com.xtremelabs.robolectric.shadows.ShadowActivity;
import com.xtremelabs.robolectric.tester.android.util.TestFragmentManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;

@Implements(value=FragmentActivity.class)
public class ShadowFragmentActivity
extends ShadowActivity {
    @RealObject
    FragmentActivity realObject;
    private TestFragmentManager fragmentManager;
    public static final String FRAGMENTS_TAG = "android:fragments";

    public void __constructor__() {
        this.fragmentManager = new TestFragmentManager(this.realObject);
    }

    @Override
    @Implementation
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (bundle != null && bundle.containsKey(FRAGMENTS_TAG)) {
            Object[] fragments;
            for (Object o : fragments = (Object[])bundle.getSerializable(FRAGMENTS_TAG)) {
                SerializedFragmentState fragmentState = (SerializedFragmentState)o;
                try {
                    Fragment fragment = fragmentState.fragmentClass.newInstance();
                    Robolectric.shadowOf(fragment).setSavedInstanceState(bundle);
                    this.fragmentManager.addFragment(fragmentState.containerId, fragmentState.tag, fragment, true);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Implementation
    public void onStart() {
        for (Fragment fragment : this.fragmentManager.getFragments().values()) {
            this.fragmentManager.startFragment(fragment);
        }
    }

    @Implementation
    public FragmentManager getSupportFragmentManager() {
        return this.fragmentManager;
    }

    @Implementation
    public void onSaveInstanceState(Bundle outState) {
        ArrayList<SerializedFragmentState> fragmentStates = new ArrayList<SerializedFragmentState>();
        for (Map.Entry<Integer, Fragment> entry : this.fragmentManager.getFragments().entrySet()) {
            fragmentStates.add(new SerializedFragmentState(entry.getKey(), entry.getValue()));
        }
        outState.putSerializable(FRAGMENTS_TAG, (Serializable)fragmentStates.toArray());
    }
}

