/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.location.Address;
import android.location.Geocoder;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

@Implements(value=Geocoder.class)
public class ShadowGeocoder {
    private String addressLine1;
    private String city;
    private String state;
    private String zip;
    private String countryCode;
    private boolean wasCalled;
    private double lastLatitude;
    private double lastLongitude;
    private String lastLocationName;
    private double simulatedLatitude;
    private double simulatedLongitude;
    private boolean shouldSimulateGeocodeException;
    private boolean hasLatitude;
    private boolean hasLongitude;
    private boolean returnNoResults = false;
    private boolean didResolution;

    @Implementation
    public List<Address> getFromLocation(double latitude, double longitude, int maxResults) throws IOException {
        this.wasCalled = true;
        this.lastLatitude = latitude;
        this.lastLongitude = longitude;
        if (this.shouldSimulateGeocodeException) {
            throw new IOException("Simulated geocode exception");
        }
        Address address = this.makeAddress();
        address.setAddressLine(0, this.addressLine1);
        address.setLocality(this.city);
        address.setAdminArea(this.state);
        address.setPostalCode(this.zip);
        address.setCountryCode(this.countryCode);
        return this.oneElementList(address);
    }

    @Implementation
    public List<Address> getFromLocationName(String locationName, int maxResults) throws IOException {
        this.didResolution = true;
        this.lastLocationName = locationName;
        if (this.shouldSimulateGeocodeException) {
            throw new IOException("Simulated geocode exception");
        }
        if (this.returnNoResults) {
            return new ArrayList<Address>();
        }
        Address address = this.makeAddress();
        address.setLatitude(this.simulatedLatitude);
        address.setLongitude(this.simulatedLongitude);
        return this.oneElementList(address);
    }

    private Address makeAddress() {
        Address address = new Address(Locale.getDefault());
        Robolectric.shadowOf(address).setSimulatedHasLatLong(this.hasLatitude, this.hasLongitude);
        return address;
    }

    public void setSimulatedResponse(String address, String city, String state, String zip, String countryCode) {
        this.addressLine1 = address;
        this.city = city;
        this.state = state;
        this.zip = zip;
        this.countryCode = countryCode;
    }

    public void setSimulatedLatLong(double lat, double lng) {
        this.simulatedLatitude = lat;
        this.simulatedLongitude = lng;
    }

    public void setShouldSimulateGeocodeException(boolean shouldSimulateException) {
        this.shouldSimulateGeocodeException = true;
    }

    public boolean wasGetFromLocationCalled() {
        return this.wasCalled;
    }

    public double getLastLongitude() {
        return this.lastLongitude;
    }

    public double getLastLatitude() {
        return this.lastLatitude;
    }

    public String getLastLocationName() {
        return this.lastLocationName;
    }

    private List<Address> oneElementList(Address address) {
        ArrayList<Address> addresses = new ArrayList<Address>();
        addresses.add(address);
        return addresses;
    }

    public void setSimulatedHasLatLong(boolean hasLatitude, boolean hasLongitude) {
        this.hasLatitude = hasLatitude;
        this.hasLongitude = hasLongitude;
    }

    public void setReturnNoResults(boolean returnNoResults) {
        this.returnNoResults = returnNoResults;
    }

    public boolean didResolution() {
        return this.didResolution;
    }
}

