/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Implements(value=Handler.class)
public class ShadowHandler {
    @RealObject
    private Handler realHandler;
    private Looper looper = Looper.myLooper();
    private List<Message> messages = new ArrayList<Message>();
    private Handler.Callback callback;

    public void __constructor__() {
        this.looper = Looper.myLooper();
    }

    public void __constructor__(Looper looper) {
        this.looper = looper;
    }

    public void __constructor__(Handler.Callback callback) {
        this.callback = callback;
    }

    @Implementation
    public boolean post(Runnable r) {
        return this.postDelayed(r, 0L);
    }

    @Implementation
    public boolean postDelayed(Runnable r, long delayMillis) {
        Robolectric.shadowOf(this.looper).post(r, delayMillis);
        return true;
    }

    @Implementation
    public final boolean postAtFrontOfQueue(Runnable runnable) {
        Robolectric.shadowOf(this.looper).postAtFrontOfQueue(runnable);
        return true;
    }

    @Implementation
    public Message obtainMessage() {
        return this.obtainMessage(0);
    }

    @Implementation
    public Message obtainMessage(int what) {
        return this.obtainMessage(what, null);
    }

    @Implementation
    public Message obtainMessage(int what, Object obj) {
        return this.obtainMessage(what, 0, 0, obj);
    }

    @Implementation
    public Message obtainMessage(int what, int arg1, int arg2) {
        return this.obtainMessage(what, arg1, arg2, null);
    }

    @Implementation
    public Message obtainMessage(int what, int arg1, int arg2, Object obj) {
        Message message = new Message();
        message.what = what;
        message.arg1 = arg1;
        message.arg2 = arg2;
        message.obj = obj;
        return message;
    }

    @Implementation
    public final boolean sendMessage(Message msg) {
        return this.sendMessageDelayed(msg, 0L);
    }

    @Implementation
    public final boolean sendMessageDelayed(final Message msg, long delayMillis) {
        this.messages.add(msg);
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (ShadowHandler.this.messages.contains(msg)) {
                    ShadowHandler.this.routeMessage(msg);
                    ShadowHandler.this.messages.remove(msg);
                }
            }
        }, delayMillis);
        return true;
    }

    private void routeMessage(Message msg) {
        if (this.callback != null) {
            this.callback.handleMessage(msg);
        } else {
            this.realHandler.handleMessage(msg);
        }
    }

    @Implementation
    public final boolean sendEmptyMessage(int what) {
        return this.sendEmptyMessageDelayed(what, 0L);
    }

    @Implementation
    public final boolean sendEmptyMessageDelayed(int what, long delayMillis) {
        Message msg = new Message();
        msg.what = what;
        return this.sendMessageDelayed(msg, delayMillis);
    }

    @Implementation
    public final Looper getLooper() {
        return this.looper;
    }

    @Implementation
    public final void removeCallbacks(Runnable r) {
        Robolectric.shadowOf(this.looper).getScheduler().remove(r);
    }

    @Implementation
    public final boolean hasMessages(int what) {
        for (Message message : this.messages) {
            if (message.what != what) continue;
            return true;
        }
        return false;
    }

    @Implementation
    public final boolean hasMessages(int what, Object object) {
        for (Message message : this.messages) {
            if (message.what != what || message.obj != object) continue;
            return true;
        }
        return false;
    }

    @Implementation
    public final void removeMessages(int what) {
        Iterator<Message> iterator = this.messages.iterator();
        while (iterator.hasNext()) {
            Message message = iterator.next();
            if (message.what != what) continue;
            iterator.remove();
        }
    }

    public static void flush() {
        ShadowHandler.idleMainLooper();
    }

    public static void idleMainLooper() {
        Robolectric.shadowOf(Looper.myLooper()).idle();
    }

    public static void runMainLooperToEndOfTasks() {
        Robolectric.shadowOf(Looper.myLooper()).runToEndOfTasks();
    }

    public static void runMainLooperOneTask() {
        Robolectric.shadowOf(Looper.myLooper()).runOneTask();
    }

    public static void runMainLooperToNextTask() {
        Robolectric.shadowOf(Looper.myLooper()).runToNextTask();
    }
}

