/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.widget.ImageView;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.res.ResourceLoader;
import com.xtremelabs.robolectric.shadows.ShadowView;

@Implements(value=ImageView.class)
public class ShadowImageView
extends ShadowView {
    private Drawable imageDrawable;
    private int alpha;
    private int resourceId;
    private Bitmap imageBitmap;
    private ImageView.ScaleType scaleType;
    private Matrix matrix;
    private int imageLevel;

    @Override
    public void applyAttributes() {
        super.applyAttributes();
        this.applyImageAttribute();
    }

    @Implementation
    public void setImageBitmap(Bitmap imageBitmap) {
        this.setImageDrawable((Drawable)new BitmapDrawable(imageBitmap));
        this.imageBitmap = imageBitmap;
    }

    @Deprecated
    public Bitmap getImageBitmap() {
        return this.imageBitmap;
    }

    @Implementation
    public void setImageDrawable(Drawable drawable) {
        this.imageDrawable = drawable;
    }

    @Implementation
    public void setImageResource(int resId) {
        this.resourceId = resId;
        this.setImageDrawable(this.buildDrawable(resId));
    }

    protected Drawable buildDrawable(int resourceId) {
        if (this.isDrawableXml(resourceId)) {
            ResourceLoader resourceLoader = Robolectric.shadowOf(Robolectric.application).getResourceLoader();
            int[] resourceIds = resourceLoader.getDrawableIds(resourceId);
            Drawable[] drawables = new Drawable[resourceIds.length];
            for (int i = 0; i < resourceIds.length; ++i) {
                drawables[i] = this.buildDrawable(resourceIds[i]);
            }
            if (resourceLoader.isAnimatableXml(resourceId)) {
                AnimationDrawable animationDrawable = new AnimationDrawable();
                for (Drawable drawable : drawables) {
                    animationDrawable.addFrame(drawable, -1);
                }
                return animationDrawable;
            }
            LayerDrawable layerDrawable = new LayerDrawable(drawables);
            Robolectric.shadowOf(layerDrawable).setLoadedFromResourceId(resourceId);
            return layerDrawable;
        }
        return new BitmapDrawable(BitmapFactory.decodeResource((Resources)this.getResources(), (int)resourceId));
    }

    private boolean isDrawableXml(int resourceId) {
        return Robolectric.shadowOf(Robolectric.application).getResourceLoader().isDrawableXml(resourceId);
    }

    @Implementation
    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    @Implementation
    public ImageView.ScaleType getScaleType() {
        return this.scaleType;
    }

    @Implementation
    public void setScaleType(ImageView.ScaleType scaleType) {
        this.scaleType = scaleType;
    }

    @Implementation
    public Drawable getDrawable() {
        return this.imageDrawable;
    }

    @Deprecated
    public Drawable getImageDrawable() {
        return this.imageDrawable;
    }

    public int getAlpha() {
        return this.alpha;
    }

    @Deprecated
    public int getResourceId() {
        return this.resourceId;
    }

    @Implementation
    public void setImageMatrix(Matrix matrix) {
        this.matrix = new Matrix(matrix);
    }

    @Implementation
    public void draw(Canvas canvas) {
        if (this.matrix != null) {
            canvas.translate(Robolectric.shadowOf(this.matrix).getTransX(), Robolectric.shadowOf(this.matrix).getTransY());
            canvas.scale(Robolectric.shadowOf(this.matrix).getScaleX(), Robolectric.shadowOf(this.matrix).getScaleY());
        }
        this.imageDrawable.draw(canvas);
    }

    private void applyImageAttribute() {
        String source = this.attributeSet.getAttributeValue("android", "src");
        if (source != null && source.startsWith("@drawable/")) {
            this.setImageResource(this.attributeSet.getAttributeResourceValue("android", "src", 0));
        }
    }

    @Implementation
    public void setImageLevel(int imageLevel) {
        this.imageLevel = imageLevel;
    }

    public int getImageLevel() {
        return this.imageLevel;
    }
}

