/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import com.xtremelabs.robolectric.shadows.ShadowBundle;
import com.xtremelabs.robolectric.util.Join;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Implements(value=Intent.class)
public class ShadowIntent {
    @RealObject
    private Intent realIntent;
    private HashMap<String, Object> extras = new HashMap();
    private String action;
    private ComponentName componentName;
    private String type;
    private Uri data;
    private int flags;
    private Class<?> intentClass;
    private String packageName;
    private Set<String> categories = new HashSet<String>();
    private String uri;

    public void __constructor__(Context packageContext, Class cls) {
        this.componentName = new ComponentName(packageContext, cls);
        this.intentClass = cls;
    }

    public void __constructor__(String action, Uri uri) {
        this.action = action;
        this.data = uri;
    }

    public void __constructor__(String action) {
        this.__constructor__(action, null);
    }

    public void __constructor__(Intent intent) {
        ShadowIntent other = Robolectric.shadowOf(intent);
        this.extras.putAll(other.extras);
        this.action = other.action;
        this.componentName = other.componentName;
        this.type = other.type;
        this.data = other.data;
        this.flags = other.flags;
        this.intentClass = other.intentClass;
        this.packageName = other.packageName;
        this.categories.addAll(other.categories);
        this.uri = other.uri;
    }

    @Implementation
    public static Intent createChooser(Intent target, CharSequence title) {
        Intent intent = new Intent("android.intent.action.CHOOSER");
        intent.putExtra("android.intent.extra.INTENT", (Parcelable)target);
        if (title != null) {
            intent.putExtra("android.intent.extra.TITLE", title);
        }
        return intent;
    }

    @Implementation
    public Intent setAction(String action) {
        this.action = action;
        return this.realIntent;
    }

    @Implementation
    public String getAction() {
        return this.action;
    }

    @Implementation
    public Intent setType(String type) {
        this.type = type;
        return this.realIntent;
    }

    @Implementation
    public String getType() {
        return this.type;
    }

    @Implementation
    public Intent addCategory(String category) {
        this.categories.add(category);
        return this.realIntent;
    }

    @Implementation
    public void removeCategory(String category) {
        this.categories.remove(category);
    }

    @Implementation
    public boolean hasCategory(String category) {
        return this.categories.contains(category);
    }

    @Implementation
    public Set<String> getCategories() {
        return this.categories;
    }

    @Implementation
    public Intent setPackage(String packageName) {
        this.packageName = packageName;
        return this.realIntent;
    }

    @Implementation
    public String getPackage() {
        return this.packageName;
    }

    @Implementation
    public Uri getData() {
        return this.data;
    }

    @Implementation
    public Intent setClass(Context packageContext, Class<?> cls) {
        this.intentClass = cls;
        return this.realIntent;
    }

    @Implementation
    public Intent setClassName(String packageName, String className) {
        this.componentName = new ComponentName(packageName, className);
        try {
            this.intentClass = Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return this.realIntent;
    }

    @Implementation
    public Intent setClassName(Context packageContext, String className) {
        this.componentName = new ComponentName(packageContext.getPackageName(), className);
        return this.realIntent;
    }

    @Implementation
    public Intent setData(Uri data) {
        this.data = data;
        return this.realIntent;
    }

    @Implementation
    public int getFlags() {
        return this.flags;
    }

    @Implementation
    public Intent setFlags(int flags) {
        this.flags = flags;
        return this.realIntent;
    }

    @Implementation
    public Intent addFlags(int flags) {
        this.flags |= flags;
        return this.realIntent;
    }

    @Implementation
    public Intent putExtras(Bundle src) {
        ShadowBundle srcShadowBundle = (ShadowBundle)Robolectric.shadowOf_(src);
        this.extras = new HashMap<String, Object>(srcShadowBundle.map);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtras(Intent src) {
        ShadowIntent srcShadowIntent = Robolectric.shadowOf(src);
        this.extras = new HashMap<String, Object>(srcShadowIntent.extras);
        return this.realIntent;
    }

    @Implementation
    public Bundle getExtras() {
        Bundle bundle = new Bundle();
        ((ShadowBundle)Robolectric.shadowOf_(bundle)).map.putAll(this.extras);
        return bundle;
    }

    @Implementation
    public Intent putExtra(String key, int value) {
        this.extras.put(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, double value) {
        this.extras.put(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, float value) {
        this.extras.put(key, Float.valueOf(value));
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, long value) {
        this.extras.put(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, Serializable value) {
        this.extras.put(key, this.serializeCycle(value));
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, Parcelable value) {
        this.extras.put(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, Parcelable[] value) {
        this.extras.put(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, String value) {
        this.extras.put(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, String[] value) {
        this.extras.put(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, boolean value) {
        this.extras.put(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, int[] value) {
        this.extras.put(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, long[] value) {
        this.extras.put(key, value);
        return this.realIntent;
    }

    @Implementation
    public int[] getIntArrayExtra(String name) {
        return (int[])this.extras.get(name);
    }

    @Implementation
    public long[] getLongArrayExtra(String name) {
        return (long[])this.extras.get(name);
    }

    @Implementation
    public boolean getBooleanExtra(String name, boolean defaultValue) {
        return this.extras.containsKey(name) ? (Boolean)this.extras.get(name) : defaultValue;
    }

    @Implementation
    public String[] getStringArrayExtra(String name) {
        return (String[])this.extras.get(name);
    }

    @Implementation
    public Intent putExtra(String key, CharSequence value) {
        this.extras.put(key, value);
        return this.realIntent;
    }

    @Implementation
    public CharSequence getCharSequenceExtra(String name) {
        return (CharSequence)this.extras.get(name);
    }

    @Implementation
    public void putExtra(String key, byte[] value) {
        this.extras.put(key, value);
    }

    @Implementation
    public Intent putStringArrayListExtra(String key, ArrayList<String> value) {
        this.extras.put(key, value);
        return this.realIntent;
    }

    @Implementation
    public ArrayList<String> getStringArrayListExtra(String name) {
        return (ArrayList)this.extras.get(name);
    }

    @Implementation
    public Intent putIntegerArrayListExtra(String key, ArrayList<Integer> value) {
        this.extras.put(key, value);
        return this.realIntent;
    }

    @Implementation
    public ArrayList<Integer> getIntegerArrayListExtra(String name) {
        return (ArrayList)this.extras.get(name);
    }

    @Implementation
    public Intent putParcelableArrayListExtra(String key, ArrayList<Parcelable> value) {
        this.extras.put(key, value);
        return this.realIntent;
    }

    @Implementation
    public ArrayList<Parcelable> getParcelableArrayListExtra(String key) {
        return (ArrayList)this.extras.get(key);
    }

    @Implementation
    public boolean hasExtra(String name) {
        return this.extras.containsKey(name);
    }

    @Implementation
    public String getStringExtra(String name) {
        return (String)this.extras.get(name);
    }

    @Implementation
    public Parcelable getParcelableExtra(String name) {
        return (Parcelable)this.extras.get(name);
    }

    @Implementation
    public Parcelable[] getParcelableArrayExtra(String name) {
        if (this.extras.get(name) instanceof Parcelable[]) {
            return (Parcelable[])this.extras.get(name);
        }
        return null;
    }

    @Implementation
    public int getIntExtra(String name, int defaultValue) {
        Integer foundValue = (Integer)this.extras.get(name);
        return foundValue == null ? defaultValue : foundValue;
    }

    @Implementation
    public long getLongExtra(String name, long defaultValue) {
        Long foundValue = (Long)this.extras.get(name);
        return foundValue == null ? defaultValue : foundValue;
    }

    @Implementation
    public double getDoubleExtra(String name, double defaultValue) {
        Double foundValue = (Double)this.extras.get(name);
        return foundValue == null ? defaultValue : foundValue;
    }

    @Implementation
    public float getFloatExtra(String name, float defaultValue) {
        Float foundValue = (Float)this.extras.get(name);
        return foundValue == null ? defaultValue : foundValue.floatValue();
    }

    @Implementation
    public byte[] getByteArrayExtra(String name) {
        return (byte[])this.extras.get(name);
    }

    @Implementation
    public Serializable getSerializableExtra(String name) {
        return (Serializable)this.extras.get(name);
    }

    @Implementation
    public void removeExtra(String name) {
        this.extras.remove(name);
    }

    @Implementation
    public Intent setComponent(ComponentName componentName) {
        this.componentName = componentName;
        return this.realIntent;
    }

    @Implementation
    public ComponentName getComponent() {
        return this.componentName;
    }

    @Implementation
    public String toURI() {
        return this.uri;
    }

    @Implementation
    public int fillIn(Intent otherIntent, int flags) {
        int changes = 0;
        ShadowIntent other = Robolectric.shadowOf(otherIntent);
        if (other.action != null && (this.action == null || (flags & 1) != 0)) {
            this.action = other.action;
            changes |= 1;
        }
        if ((other.data != null || other.type != null) && (this.data == null && this.type == null || (flags & 2) != 0)) {
            this.data = other.data;
            this.type = other.type;
            changes |= 2;
        }
        if (!other.categories.isEmpty() && (this.categories.isEmpty() || (flags & 4) != 0)) {
            this.categories.addAll(other.categories);
            changes |= 4;
        }
        if (other.packageName != null && (this.packageName == null || (flags & 0x10) != 0)) {
            this.packageName = other.packageName;
            changes |= 0x10;
        }
        if (other.componentName != null && (flags & 8) != 0) {
            this.componentName = other.componentName;
            changes |= 8;
        }
        this.extras.putAll(other.extras);
        return changes;
    }

    @Implementation
    public boolean filterEquals(Intent other) {
        if (other == null) {
            return false;
        }
        if (this.getAction() != other.getAction() && (this.getAction() != null ? !this.getAction().equals(other.getAction()) : !other.getAction().equals(this.getAction()))) {
            return false;
        }
        if (this.getData() != other.getData() && (this.getData() != null ? !this.getData().equals((Object)other.getData()) : !other.getData().equals((Object)this.getData()))) {
            return false;
        }
        if (this.getType() != other.getType() && (this.getType() != null ? !this.getType().equals(other.getType()) : !other.getType().equals(this.getType()))) {
            return false;
        }
        if (this.getPackage() != other.getPackage() && (this.getPackage() != null ? !this.getPackage().equals(other.getPackage()) : !other.getPackage().equals(this.getPackage()))) {
            return false;
        }
        if (this.getComponent() != other.getComponent() && (this.getComponent() != null ? !this.getComponent().equals((Object)other.getComponent()) : !other.getComponent().equals((Object)this.getComponent()))) {
            return false;
        }
        return this.getCategories() == other.getCategories() || !(this.getCategories() != null ? !((Object)this.getCategories()).equals(other.getCategories()) : !((Object)other.getCategories()).equals(this.getCategories()));
    }

    @Deprecated
    public boolean realIntentEquals(ShadowIntent o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.action != null ? !this.action.equals(o.action) : o.action != null) {
            return false;
        }
        if (this.componentName != null ? !this.componentName.equals((Object)o.componentName) : o.componentName != null) {
            return false;
        }
        if (this.data != null ? !this.data.equals((Object)o.data) : o.data != null) {
            return false;
        }
        if (this.extras != null ? !this.extras.equals(o.extras) : o.extras != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(o.type) : o.type != null) {
            return false;
        }
        return !(this.categories != null ? !((Object)this.categories).equals(o.categories) : o.categories != null);
    }

    @Implementation
    public int hashCode() {
        int result = this.extras != null ? this.extras.hashCode() : 0;
        result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
        result = 31 * result + (this.componentName != null ? this.componentName.hashCode() : 0);
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + this.flags;
        return result;
    }

    @Implementation
    public boolean equals(Object o) {
        if (!(o instanceof Intent)) {
            return false;
        }
        return this.realIntentEquals(Robolectric.shadowOf((Intent)o));
    }

    public Class<?> getIntentClass() {
        return this.intentClass;
    }

    @Implementation
    public String toString() {
        return "Intent{" + Join.join(", ", this.ifWeHave(this.componentName, "componentName"), this.ifWeHave(this.action, "action"), this.ifWeHave(this.extras, "extras"), this.ifWeHave(this.data, "data"), this.ifWeHave(this.type, "type")) + '}';
    }

    private Serializable serializeCycle(Serializable serializable) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream output = new ObjectOutputStream(byteArrayOutputStream);
            output.writeObject(serializable);
            output.close();
            byte[] bytes = byteArrayOutputStream.toByteArray();
            ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(bytes));
            return (Serializable)input.readObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private String ifWeHave(Object o, String name) {
        if (o == null) {
            return null;
        }
        if (o instanceof Map && ((Map)o).isEmpty()) {
            return null;
        }
        return name + "=" + o;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }
}

