/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.app.Application;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.AppSingletonizer;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.res.ResourceLoader;
import com.xtremelabs.robolectric.shadows.ShadowApplication;

@Implements(value=LayoutInflater.class)
public class ShadowLayoutInflater {
    private static AppSingletonizer<LayoutInflater> instances = new LayoutInflaterAppSingletonizer();
    private Context context;

    private static LayoutInflater bind(LayoutInflater layoutInflater, Context context) {
        Robolectric.shadowOf((LayoutInflater)layoutInflater).context = context;
        return layoutInflater;
    }

    @Implementation
    public static LayoutInflater from(Context context) {
        return ShadowLayoutInflater.bind(instances.getInstance(context), context);
    }

    @Implementation
    public Context getContext() {
        return this.context;
    }

    @Implementation
    public View inflate(int resource, ViewGroup root, boolean attachToRoot) {
        return this.getResourceLoader().inflateView(this.context, resource, (ViewGroup)(attachToRoot ? root : null));
    }

    @Implementation
    public View inflate(int resource, ViewGroup root) {
        return this.inflate(resource, root, root != null);
    }

    private ResourceLoader getResourceLoader() {
        return Robolectric.shadowOf(this.context.getApplicationContext()).getResourceLoader();
    }

    private static class LayoutInflaterAppSingletonizer
    extends AppSingletonizer<LayoutInflater> {
        public LayoutInflaterAppSingletonizer() {
            super(LayoutInflater.class);
        }

        @Override
        protected LayoutInflater get(ShadowApplication shadowApplication) {
            return shadowApplication.getLayoutInflater();
        }

        @Override
        protected void set(ShadowApplication shadowApplication, LayoutInflater instance) {
            shadowApplication.layoutInflater = instance;
        }

        @Override
        protected LayoutInflater createInstance(Application applicationContext) {
            return new MyLayoutInflater((Context)applicationContext);
        }

        private static class MyLayoutInflater
        extends LayoutInflater {
            public MyLayoutInflater(Context context) {
                super(context);
            }

            public LayoutInflater cloneInContext(Context newContext) {
                return ShadowLayoutInflater.bind(new MyLayoutInflater(newContext), newContext);
            }
        }
    }
}

