/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.app.ListActivity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.shadows.ShadowActivity;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@Implements(value=ListActivity.class)
public class ShadowListActivity
extends ShadowActivity {
    private ListView listView;
    private ListAdapter listAdapter;

    @Implementation
    public ListView getListView() {
        if (this.listView == null && (this.listView = this.findListView(this.contentView)) == null) {
            throw new RuntimeException("No ListView found under content view");
        }
        return this.listView;
    }

    public void setListView(ListView view) {
        this.listView = view;
    }

    @Implementation
    public void setListAdapter(ListAdapter listAdapter) {
        this.listAdapter = listAdapter;
        ListView lv = this.findListView(this.contentView);
        if (lv != null) {
            lv.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                    try {
                        Method handler = ShadowListActivity.this.realActivity.getClass().getDeclaredMethod("onListItemClick", ListView.class, View.class, Integer.TYPE, Long.TYPE);
                        handler.setAccessible(true);
                        handler.invoke((Object)ShadowListActivity.this.realActivity, parent, view, position, id);
                    }
                    catch (NoSuchMethodException ignored) {
                    }
                    catch (InvocationTargetException ignored) {
                    }
                    catch (IllegalAccessException ignored) {
                        // empty catch block
                    }
                }
            });
            lv.setAdapter(listAdapter);
        }
    }

    @Implementation
    public ListAdapter getListAdapter() {
        return this.listAdapter;
    }

    private ListView findListView(View parent) {
        if (parent instanceof ListView) {
            return (ListView)parent;
        }
        if (parent instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)parent;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                ListView listView = this.findListView(viewGroup.getChildAt(i));
                if (listView == null) continue;
                return listView;
            }
        }
        return null;
    }
}

