/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.view.View;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import com.xtremelabs.robolectric.shadows.ShadowAbsListView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Implements(value=ListView.class)
public class ShadowListView
extends ShadowAbsListView {
    @RealObject
    private ListView realListView;
    private boolean itemsCanFocus;
    private List<View> headerViews = new ArrayList<View>();
    private List<View> footerViews = new ArrayList<View>();

    @Override
    @Implementation
    public View findViewById(int id) {
        View child = super.findViewById(id);
        if (child == null && (child = this.findView(this.headerViews, id)) == null) {
            child = this.findView(this.footerViews, id);
        }
        return child;
    }

    private View findView(List<View> views, int viewId) {
        View v;
        View child = null;
        Iterator<View> i$ = views.iterator();
        while (i$.hasNext() && (child = (v = i$.next()).findViewById(viewId)) == null) {
        }
        return child;
    }

    @Implementation
    public void setItemsCanFocus(boolean itemsCanFocus) {
        this.itemsCanFocus = itemsCanFocus;
    }

    @Override
    @Implementation
    public boolean performItemClick(View view, int position, long id) {
        AdapterView.OnItemClickListener onItemClickListener = this.getOnItemClickListener();
        if (onItemClickListener != null) {
            onItemClickListener.onItemClick((AdapterView)this.realListView, view, position, id);
            return true;
        }
        return false;
    }

    @Implementation
    public void setAdapter(ListAdapter adapter) {
        super.setAdapter((Adapter)adapter);
    }

    @Implementation
    public void addHeaderView(View headerView) {
        this.addHeaderView(headerView, null, true);
    }

    @Implementation
    public void addHeaderView(View headerView, Object data, boolean isSelectable) {
        this.ensureAdapterNotSet("header");
        this.headerViews.add(headerView);
        this.realListView.addView(headerView);
    }

    @Implementation
    public int getHeaderViewsCount() {
        return this.headerViews.size();
    }

    @Implementation
    public int getFooterViewsCount() {
        return this.footerViews.size();
    }

    @Implementation
    public void addFooterView(View footerView, Object data, boolean isSelectable) {
        this.ensureAdapterNotSet("footer");
        this.footerViews.add(footerView);
        this.realListView.addView(footerView);
    }

    @Implementation
    public void addFooterView(View footerView) {
        this.addFooterView(footerView, null, false);
    }

    @Override
    @Implementation
    public void removeAllViews() {
        throw new UnsupportedOperationException();
    }

    @Implementation
    public void removeView(View view) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Implementation
    public void removeViewAt(int index) {
        throw new UnsupportedOperationException();
    }

    private void ensureAdapterNotSet(String view) {
        if (this.getAdapter() != null) {
            throw new IllegalStateException("Cannot add " + view + " view to list -- setAdapter has already been called");
        }
    }

    public boolean isItemsCanFocus() {
        return this.itemsCanFocus;
    }

    public List<View> getHeaderViews() {
        return this.headerViews;
    }

    public void setHeaderViews(List<View> headerViews) {
        this.headerViews = headerViews;
    }

    public List<View> getFooterViews() {
        return this.footerViews;
    }

    public void setFooterViews(List<View> footerViews) {
        this.footerViews = footerViews;
    }

    @Override
    protected void addViews() {
        for (View headerView : this.headerViews) {
            this.addView(headerView);
        }
        super.addViews();
        for (View footerView : this.footerViews) {
            this.addView(footerView);
        }
    }
}

