/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.location.Location;
import android.os.Bundle;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;

@Implements(value=Location.class)
public class ShadowLocation {
    private long time;
    private String provider;
    private double latitude;
    private double longitude;
    private float accuracy;
    private double mLat1 = 0.0;
    private double mLon1 = 0.0;
    private double mLat2 = 0.0;
    private double mLon2 = 0.0;
    private float mDistance = 0.0f;
    private float mInitialBearing = 0.0f;
    private float[] mResults = new float[2];
    private Bundle extras = new Bundle();

    public void __constructor__(String provider) {
        this.provider = provider;
        this.time = System.currentTimeMillis();
    }

    @Implementation
    public String getProvider() {
        return this.provider;
    }

    @Implementation
    public void setProvider(String provider) {
        this.provider = provider;
    }

    @Implementation
    public long getTime() {
        return this.time;
    }

    @Implementation
    public void setTime(long time) {
        this.time = time;
    }

    @Implementation
    public double getLatitude() {
        return this.latitude;
    }

    @Implementation
    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    @Implementation
    public double getLongitude() {
        return this.longitude;
    }

    @Implementation
    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    @Implementation
    public float getAccuracy() {
        return this.accuracy;
    }

    @Implementation
    public void setAccuracy(float accuracy) {
        this.accuracy = accuracy;
    }

    @Implementation
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if ((o = Robolectric.shadowOf_(o)) == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (this == o) {
            return true;
        }
        ShadowLocation that = (ShadowLocation)o;
        if (Double.compare(that.latitude, this.latitude) != 0) {
            return false;
        }
        if (Double.compare(that.longitude, this.longitude) != 0) {
            return false;
        }
        if (this.time != that.time) {
            return false;
        }
        if (this.provider != null ? !this.provider.equals(that.provider) : that.provider != null) {
            return false;
        }
        return this.accuracy == that.accuracy;
    }

    @Implementation
    public int hashCode() {
        int result = (int)(this.time ^ this.time >>> 32);
        result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
        long temp = this.latitude != 0.0 ? Double.doubleToLongBits(this.latitude) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.longitude != 0.0 ? Double.doubleToLongBits(this.longitude) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.accuracy != 0.0f ? (long)Float.floatToIntBits(this.accuracy) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Implementation
    public String toString() {
        return "Location{time=" + this.time + ", provider='" + this.provider + '\'' + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", accuracy=" + this.accuracy + '}';
    }

    private static void computeDistanceAndBearing(double lat1, double lon1, double lat2, double lon2, float[] results) {
        float distance;
        int MAXITERS = 20;
        lat1 *= Math.PI / 180;
        lat2 *= Math.PI / 180;
        double a = 6378137.0;
        double b = 6356752.3142;
        double f = (a - b) / a;
        double aSqMinusBSqOverBSq = (a * a - b * b) / (b * b);
        double L = (lon2 *= Math.PI / 180) - (lon1 *= Math.PI / 180);
        double A = 0.0;
        double U1 = Math.atan((1.0 - f) * Math.tan(lat1));
        double U2 = Math.atan((1.0 - f) * Math.tan(lat2));
        double cosU1 = Math.cos(U1);
        double cosU2 = Math.cos(U2);
        double sinU1 = Math.sin(U1);
        double sinU2 = Math.sin(U2);
        double cosU1cosU2 = cosU1 * cosU2;
        double sinU1sinU2 = sinU1 * sinU2;
        double sigma = 0.0;
        double deltaSigma = 0.0;
        double cosSqAlpha = 0.0;
        double cos2SM = 0.0;
        double cosSigma = 0.0;
        double sinSigma = 0.0;
        double cosLambda = 0.0;
        double sinLambda = 0.0;
        double lambda = L;
        for (int iter = 0; iter < MAXITERS; ++iter) {
            double lambdaOrig = lambda;
            cosLambda = Math.cos(lambda);
            sinLambda = Math.sin(lambda);
            double t1 = cosU2 * sinLambda;
            double t2 = cosU1 * sinU2 - sinU1 * cosU2 * cosLambda;
            double sinSqSigma = t1 * t1 + t2 * t2;
            sinSigma = Math.sqrt(sinSqSigma);
            cosSigma = sinU1sinU2 + cosU1cosU2 * cosLambda;
            sigma = Math.atan2(sinSigma, cosSigma);
            double sinAlpha = sinSigma == 0.0 ? 0.0 : cosU1cosU2 * sinLambda / sinSigma;
            cosSqAlpha = 1.0 - sinAlpha * sinAlpha;
            cos2SM = cosSqAlpha == 0.0 ? 0.0 : cosSigma - 2.0 * sinU1sinU2 / cosSqAlpha;
            double uSquared = cosSqAlpha * aSqMinusBSqOverBSq;
            A = 1.0 + uSquared / 16384.0 * (4096.0 + uSquared * (-768.0 + uSquared * (320.0 - 175.0 * uSquared)));
            double B = uSquared / 1024.0 * (256.0 + uSquared * (-128.0 + uSquared * (74.0 - 47.0 * uSquared)));
            double C = f / 16.0 * cosSqAlpha * (4.0 + f * (4.0 - 3.0 * cosSqAlpha));
            double cos2SMSq = cos2SM * cos2SM;
            deltaSigma = B * sinSigma * (cos2SM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SMSq) - B / 6.0 * cos2SM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SMSq)));
            lambda = L + (1.0 - C) * f * sinAlpha * (sigma + C * sinSigma * (cos2SM + C * cosSigma * (-1.0 + 2.0 * cos2SM * cos2SM)));
            double delta = (lambda - lambdaOrig) / lambda;
            if (Math.abs(delta) < 1.0E-12) break;
        }
        results[0] = distance = (float)(b * A * (sigma - deltaSigma));
        if (results.length > 1) {
            float initialBearing = (float)Math.atan2(cosU2 * sinLambda, cosU1 * sinU2 - sinU1 * cosU2 * cosLambda);
            results[1] = initialBearing = (float)((double)initialBearing * 57.29577951308232);
            if (results.length > 2) {
                float finalBearing = (float)Math.atan2(cosU1 * sinLambda, -sinU1 * cosU2 + cosU1 * sinU2 * cosLambda);
                results[2] = finalBearing = (float)((double)finalBearing * 57.29577951308232);
            }
        }
    }

    @Implementation
    public static void distanceBetween(double startLatitude, double startLongitude, double endLatitude, double endLongitude, float[] results) {
        if (results == null || results.length < 1) {
            throw new IllegalArgumentException("results is null or has length < 1");
        }
        ShadowLocation.computeDistanceAndBearing(startLatitude, startLongitude, endLatitude, endLongitude, results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    public float distanceTo(Location dest) {
        float[] fArray = this.mResults;
        synchronized (this.mResults) {
            if (this.latitude != this.mLat1 || this.longitude != this.mLon1 || dest.getLatitude() != this.mLat2 || dest.getLongitude() != this.mLon2) {
                ShadowLocation.computeDistanceAndBearing(this.latitude, this.longitude, dest.getLatitude(), dest.getLongitude(), this.mResults);
                this.mLat1 = this.latitude;
                this.mLon1 = this.longitude;
                this.mLat2 = dest.getLatitude();
                this.mLon2 = dest.getLongitude();
                this.mDistance = this.mResults[0];
                this.mInitialBearing = this.mResults[1];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.mDistance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    public float bearingTo(Location dest) {
        float[] fArray = this.mResults;
        synchronized (this.mResults) {
            if (this.latitude != this.mLat1 || this.longitude != this.mLon1 || dest.getLatitude() != this.mLat2 || dest.getLongitude() != this.mLon2) {
                ShadowLocation.computeDistanceAndBearing(this.latitude, this.longitude, dest.getLatitude(), dest.getLongitude(), this.mResults);
                this.mLat1 = this.latitude;
                this.mLon1 = this.longitude;
                this.mLat2 = dest.getLatitude();
                this.mLon2 = dest.getLongitude();
                this.mDistance = this.mResults[0];
                this.mInitialBearing = this.mResults[1];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.mInitialBearing;
        }
    }

    @Implementation
    public Bundle getExtras() {
        return this.extras;
    }

    @Implementation
    public void setExtras(Bundle extras) {
        this.extras = extras;
    }
}

