/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.app.PendingIntent;
import android.content.Intent;
import android.location.Criteria;
import android.location.GpsStatus;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Looper;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Implements(value=LocationManager.class)
public class ShadowLocationManager {
    private final Map<String, LocationProviderEntry> providersEnabled = new LinkedHashMap<String, LocationProviderEntry>();
    private final Map<String, Location> lastKnownLocations = new HashMap<String, Location>();
    private final Map<PendingIntent, Criteria> requestLocationUdpateCriteriaPendingIntents = new HashMap<PendingIntent, Criteria>();
    private final Map<PendingIntent, String> requestLocationUdpateProviderPendingIntents = new HashMap<PendingIntent, String>();
    private final ArrayList<GpsStatus.Listener> gpsStatusListeners = new ArrayList();
    private Criteria lastBestProviderCriteria;
    private boolean lastBestProviderEnabled;
    private String bestEnabledProvider;
    private String bestDisabledProvider;
    private final List<LocationListener> requestLocationUdpateListeners = new ArrayList<LocationListener>();

    @Implementation
    public boolean isProviderEnabled(String provider) {
        LocationProviderEntry map = this.providersEnabled.get(provider);
        if (map != null) {
            Boolean isEnabled = map.getKey();
            return isEnabled == null ? true : isEnabled;
        }
        return false;
    }

    @Implementation
    public List<String> getAllProviders() {
        LinkedHashSet<String> allKnownProviders = new LinkedHashSet<String>(this.providersEnabled.keySet());
        allKnownProviders.add("gps");
        allKnownProviders.add("network");
        allKnownProviders.add("passive");
        return new ArrayList<String>(allKnownProviders);
    }

    public void setProviderEnabled(String provider, boolean isEnabled) {
        this.setProviderEnabled(provider, isEnabled, null);
    }

    public void setProviderEnabled(String provider, boolean isEnabled, List<Criteria> criteria) {
        LocationProviderEntry providerEntry = this.providersEnabled.get(provider);
        if (providerEntry == null) {
            providerEntry = new LocationProviderEntry();
        }
        providerEntry.enabled = isEnabled;
        providerEntry.criteria = criteria;
        this.providersEnabled.put(provider, providerEntry);
        List<LocationListener> locationUpdateListeners = this.requestLocationUdpateListeners;
        for (LocationListener locationUpdateListener : locationUpdateListeners) {
            if (isEnabled) {
                locationUpdateListener.onProviderEnabled(provider);
                continue;
            }
            locationUpdateListener.onProviderDisabled(provider);
        }
        Intent intent = new Intent();
        intent.putExtra("providerEnabled", isEnabled);
        Robolectric.getShadowApplication().sendBroadcast(intent);
        Set<PendingIntent> requestLocationUdpatePendingIntentSet = this.requestLocationUdpateCriteriaPendingIntents.keySet();
        for (PendingIntent requestLocationUdpatePendingIntent : requestLocationUdpatePendingIntentSet) {
            try {
                requestLocationUdpatePendingIntent.send();
            }
            catch (PendingIntent.CanceledException e) {
                this.requestLocationUdpateCriteriaPendingIntents.remove(requestLocationUdpatePendingIntent);
            }
        }
        if (provider.equals(this.bestEnabledProvider) && !isEnabled) {
            this.bestEnabledProvider = null;
        }
    }

    @Implementation
    public List<String> getProviders(boolean enabledOnly) {
        ArrayList<String> enabledProviders = new ArrayList<String>();
        for (String provider : this.providersEnabled.keySet()) {
            if (enabledOnly && !this.providersEnabled.get(provider).getKey().booleanValue()) continue;
            enabledProviders.add(provider);
        }
        return enabledProviders;
    }

    @Implementation
    public Location getLastKnownLocation(String provider) {
        return this.lastKnownLocations.get(provider);
    }

    @Implementation
    public boolean addGpsStatusListener(GpsStatus.Listener listener) {
        if (!this.gpsStatusListeners.contains(listener)) {
            this.gpsStatusListeners.add(listener);
        }
        return true;
    }

    @Implementation
    public void removeGpsStatusListener(GpsStatus.Listener listener) {
        this.gpsStatusListeners.remove(listener);
    }

    @Implementation
    public String getBestProvider(Criteria criteria, boolean enabled) {
        this.lastBestProviderCriteria = criteria;
        this.lastBestProviderEnabled = enabled;
        if (criteria == null) {
            return this.getBestProviderWithNoCriteria(enabled);
        }
        return this.getBestProviderWithCriteria(criteria, enabled);
    }

    private String getBestProviderWithCriteria(Criteria criteria, boolean enabled) {
        List<String> providers = this.getProviders(enabled);
        int powerRequirement = criteria.getPowerRequirement();
        int accuracy = criteria.getAccuracy();
        for (String provider : providers) {
            Object criteriaList;
            LocationProviderEntry locationProviderEntry = this.providersEnabled.get(provider);
            if (locationProviderEntry == null || (criteriaList = locationProviderEntry.getValue()) == null) continue;
            Iterator i$ = criteriaList.iterator();
            while (i$.hasNext()) {
                Criteria criteriaListItem = (Criteria)i$.next();
                if (criteria.equals(criteriaListItem)) {
                    return provider;
                }
                if (criteriaListItem.getAccuracy() == accuracy) {
                    return provider;
                }
                if (criteriaListItem.getPowerRequirement() != powerRequirement) continue;
                return provider;
            }
        }
        for (String provider : providers) {
            if (provider.equals("network") && (accuracy == 2 || powerRequirement == 1)) {
                return provider;
            }
            if (!provider.equals("gps") || accuracy != 1 || powerRequirement == 1) continue;
            return provider;
        }
        return providers.isEmpty() ? null : providers.get(0);
    }

    private String getBestProviderWithNoCriteria(boolean enabled) {
        List<String> providers = this.getProviders(enabled);
        if (enabled && this.bestEnabledProvider != null) {
            return this.bestEnabledProvider;
        }
        if (this.bestDisabledProvider != null) {
            return this.bestDisabledProvider;
        }
        if (providers.contains("gps")) {
            return "gps";
        }
        if (providers.contains("network")) {
            return "network";
        }
        return null;
    }

    @Implementation
    public void requestLocationUpdates(String provider, long minTime, float minDistance, LocationListener listener) {
        this.requestLocationUdpateListeners.add(listener);
    }

    @Implementation
    public void requestLocationUpdates(String provider, long minTime, float minDistance, LocationListener listener, Looper looper) {
        this.requestLocationUdpateListeners.add(listener);
    }

    @Implementation
    public void requestLocationUpdates(long minTime, float minDistance, Criteria criteria, PendingIntent pendingIntent) {
        if (pendingIntent == null) {
            throw new IllegalStateException("Intent must not be null");
        }
        if (this.getBestProvider(criteria, true) == null) {
            throw new IllegalArgumentException("no providers found for criteria");
        }
        this.requestLocationUdpateCriteriaPendingIntents.put(pendingIntent, criteria);
    }

    @Implementation
    public void requestLocationUpdates(String provider, long minTime, float minDistance, PendingIntent pendingIntent) {
        if (pendingIntent == null) {
            throw new IllegalStateException("Intent must not be null");
        }
        if (!this.providersEnabled.containsKey(provider)) {
            throw new IllegalArgumentException("no providers found");
        }
        this.requestLocationUdpateProviderPendingIntents.put(pendingIntent, provider);
    }

    @Implementation
    public void removeUpdates(LocationListener listener) {
        while (this.requestLocationUdpateListeners.remove(listener)) {
        }
    }

    @Implementation
    public void removeUpdates(PendingIntent pendingIntent) {
        while (this.requestLocationUdpateCriteriaPendingIntents.remove(pendingIntent) != null) {
        }
        while (this.requestLocationUdpateProviderPendingIntents.remove(pendingIntent) != null) {
        }
    }

    public boolean hasGpsStatusListener(GpsStatus.Listener listener) {
        return this.gpsStatusListeners.contains(listener);
    }

    public Criteria getLastBestProviderCriteria() {
        return this.lastBestProviderCriteria;
    }

    public boolean getLastBestProviderEnabledOnly() {
        return this.lastBestProviderEnabled;
    }

    public boolean setBestProvider(String provider, boolean enabled, List<Criteria> criteria) throws Exception {
        LocationProviderEntry entry;
        if (!this.getAllProviders().contains(provider)) {
            throw new IllegalStateException("Best provider is not a known provider");
        }
        for (String prvdr : this.providersEnabled.keySet()) {
            if (!provider.equals(prvdr) || this.providersEnabled.get(prvdr).enabled == enabled) continue;
            return false;
        }
        if (enabled) {
            this.bestEnabledProvider = provider;
            if (provider.equals(this.bestDisabledProvider)) {
                this.bestDisabledProvider = null;
            }
        } else {
            this.bestDisabledProvider = provider;
            if (provider.equals(this.bestEnabledProvider)) {
                this.bestEnabledProvider = null;
            }
        }
        if (criteria == null) {
            return true;
        }
        if (!this.providersEnabled.containsKey(provider)) {
            entry = new LocationProviderEntry();
            entry.enabled = enabled;
            entry.criteria = criteria;
        } else {
            entry = this.providersEnabled.get(provider);
        }
        this.providersEnabled.put(provider, entry);
        return true;
    }

    public boolean setBestProvider(String provider, boolean enabled) throws Exception {
        return this.setBestProvider(provider, enabled, null);
    }

    public void setLastKnownLocation(String provider, Location location) {
        this.lastKnownLocations.put(provider, location);
    }

    public List<LocationListener> getRequestLocationUpdateListeners() {
        return this.requestLocationUdpateListeners;
    }

    public Map<PendingIntent, Criteria> getRequestLocationUdpateCriteriaPendingIntents() {
        return this.requestLocationUdpateCriteriaPendingIntents;
    }

    public Map<PendingIntent, String> getRequestLocationUdpateProviderPendingIntents() {
        return this.requestLocationUdpateProviderPendingIntents;
    }

    private final class LocationProviderEntry
    implements Map.Entry<Boolean, List<Criteria>> {
        private Boolean enabled;
        private List<Criteria> criteria;

        private LocationProviderEntry() {
        }

        @Override
        public Boolean getKey() {
            return this.enabled;
        }

        @Override
        public List<Criteria> getValue() {
            return this.criteria;
        }

        @Override
        public List<Criteria> setValue(List<Criteria> criteria) {
            List<Criteria> oldCriteria = this.criteria;
            this.criteria = criteria;
            return oldCriteria;
        }
    }
}

