/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.util.Log;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

@Implements(value=Log.class)
public class ShadowLog {
    private static List<LogItem> logs = new ArrayList<LogItem>();
    public static PrintStream stream;

    @Implementation
    public static void e(String tag, String msg) {
        ShadowLog.e(tag, msg, null);
    }

    @Implementation
    public static void e(String tag, String msg, Throwable throwable) {
        ShadowLog.addLog(6, tag, msg, throwable);
    }

    @Implementation
    public static void d(String tag, String msg) {
        ShadowLog.d(tag, msg, null);
    }

    @Implementation
    public static void d(String tag, String msg, Throwable throwable) {
        ShadowLog.addLog(3, tag, msg, throwable);
    }

    @Implementation
    public static void i(String tag, String msg) {
        ShadowLog.i(tag, msg, null);
    }

    @Implementation
    public static void i(String tag, String msg, Throwable throwable) {
        ShadowLog.addLog(4, tag, msg, throwable);
    }

    @Implementation
    public static void v(String tag, String msg) {
        ShadowLog.v(tag, msg, null);
    }

    @Implementation
    public static void v(String tag, String msg, Throwable throwable) {
        ShadowLog.addLog(2, tag, msg, throwable);
    }

    @Implementation
    public static void w(String tag, String msg) {
        ShadowLog.w(tag, msg, null);
    }

    @Implementation
    public static void w(String tag, Throwable throwable) {
        ShadowLog.w(tag, null, throwable);
    }

    @Implementation
    public static void w(String tag, String msg, Throwable throwable) {
        ShadowLog.addLog(5, tag, msg, throwable);
    }

    @Implementation
    public static void wtf(String tag, String msg) {
        ShadowLog.wtf(tag, msg, null);
    }

    @Implementation
    public static void wtf(String tag, String msg, Throwable throwable) {
        ShadowLog.addLog(7, tag, msg, throwable);
    }

    @Implementation
    public static boolean isLoggable(String tag, int level) {
        return stream != null || level >= 4;
    }

    private static void addLog(int level, String tag, String msg, Throwable throwable) {
        if (stream != null) {
            ShadowLog.logToStream(stream, level, tag, msg, throwable);
        }
        logs.add(new LogItem(level, tag, msg, throwable));
    }

    private static void logToStream(PrintStream ps, int level, String tag, String msg, Throwable throwable) {
        char c;
        switch (level) {
            case 7: {
                c = 'A';
                break;
            }
            case 3: {
                c = 'D';
                break;
            }
            case 6: {
                c = 'E';
                break;
            }
            case 5: {
                c = 'W';
                break;
            }
            case 4: {
                c = 'I';
                break;
            }
            case 2: {
                c = 'V';
                break;
            }
            default: {
                c = '?';
            }
        }
        ps.println(c + "/" + tag + ": " + msg);
        if (throwable != null) {
            throwable.printStackTrace(ps);
        }
    }

    public static List<LogItem> getLogs() {
        return logs;
    }

    public static void reset() {
        logs.clear();
    }

    public static class LogItem {
        public final int type;
        public final String tag;
        public final String msg;
        public final Throwable throwable;

        public LogItem(int type, String tag, String msg, Throwable throwable) {
            this.type = type;
            this.tag = tag;
            this.msg = msg;
            this.throwable = throwable;
        }
    }
}

