/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.os.Looper;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.util.Scheduler;

@Implements(value=Looper.class)
public class ShadowLooper {
    private static ThreadLocal<Looper> looperForThread = ShadowLooper.makeThreadLocalLoopers();
    private Scheduler scheduler = new Scheduler();

    private static synchronized ThreadLocal<Looper> makeThreadLocalLoopers() {
        return new ThreadLocal<Looper>(){

            @Override
            protected Looper initialValue() {
                return Robolectric.Reflection.newInstanceOf(Looper.class);
            }
        };
    }

    public static void resetThreadLoopers() {
        looperForThread = ShadowLooper.makeThreadLocalLoopers();
    }

    @Implementation
    public static Looper getMainLooper() {
        return Robolectric.getShadowApplication().getMainLooper();
    }

    @Implementation
    public static synchronized Looper myLooper() {
        return looperForThread.get();
    }

    public static void pauseLooper(Looper looper) {
        Robolectric.shadowOf(looper).pause();
    }

    public static void unPauseLooper(Looper looper) {
        Robolectric.shadowOf(looper).unPause();
    }

    public static void pauseMainLooper() {
        ShadowLooper.pauseLooper(Looper.getMainLooper());
    }

    public static void unPauseMainLooper() {
        ShadowLooper.unPauseLooper(Looper.getMainLooper());
    }

    public static void idleMainLooper(long interval) {
        Robolectric.shadowOf(Looper.getMainLooper()).idle(interval);
    }

    public void idle() {
        this.scheduler.advanceBy(0L);
    }

    public void idle(long intervalMillis) {
        this.scheduler.advanceBy(intervalMillis);
    }

    public void runToEndOfTasks() {
        this.scheduler.advanceToLastPostedRunnable();
    }

    public void runToNextTask() {
        this.scheduler.advanceToNextPostedRunnable();
    }

    public void runOneTask() {
        this.scheduler.runOneTask();
    }

    public void post(Runnable runnable, long delayMillis) {
        this.scheduler.postDelayed(runnable, delayMillis);
    }

    public void postAtFrontOfQueue(Runnable runnable) {
        this.scheduler.postAtFrontOfQueue(runnable);
    }

    public void pause() {
        this.scheduler.pause();
    }

    public void unPause() {
        this.scheduler.unPause();
    }

    public void reset() {
        this.scheduler.reset();
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }
}

