/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapController;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.shadows.ShadowMapView;

@Implements(value=MapController.class)
public class ShadowMapController {
    private ShadowMapView shadowMapView;
    private GeoPoint geoPointAnimatedTo;

    @Implementation
    public void animateTo(GeoPoint geoPoint) {
        this.setCenter(geoPoint);
        this.geoPointAnimatedTo = geoPoint;
    }

    @Implementation
    public void animateTo(GeoPoint geoPoint, Runnable runnable) {
        this.animateTo(geoPoint);
        runnable.run();
    }

    @Implementation
    public void setCenter(GeoPoint geoPoint) {
        this.shadowMapView.mapCenter = geoPoint;
    }

    @Implementation
    public void zoomToSpan(int latSpan, int lngSpan) {
        this.shadowMapView.latitudeSpan = latSpan;
        this.shadowMapView.longitudeSpan = lngSpan;
    }

    @Implementation
    public boolean zoomIn() {
        ++this.shadowMapView.zoomLevel;
        return true;
    }

    @Implementation
    public boolean zoomOut() {
        --this.shadowMapView.zoomLevel;
        return true;
    }

    @Implementation
    public int setZoom(int i) {
        this.shadowMapView.zoomLevel = i;
        return i;
    }

    public ShadowMapView getShadowMapView() {
        return this.shadowMapView;
    }

    public GeoPoint getGeoPointAnimatedTo() {
        return this.geoPointAnimatedTo;
    }

    void setShadowMapView(ShadowMapView shadowMapView) {
        this.shadowMapView = shadowMapView;
    }
}

