/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.content.Context;
import android.graphics.Point;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ZoomButtonsController;
import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapController;
import com.google.android.maps.MapView;
import com.google.android.maps.Overlay;
import com.google.android.maps.Projection;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.RobolectricForMaps;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.shadows.ShadowMapController;
import com.xtremelabs.robolectric.shadows.ShadowViewGroup;
import java.util.ArrayList;
import java.util.List;

@Implements(value=MapView.class)
public class ShadowMapView
extends ShadowViewGroup {
    private boolean satelliteOn;
    private MapController mapController;
    private List<Overlay> overlays = new ArrayList<Overlay>();
    GeoPoint mapCenter = new GeoPoint(10, 10);
    int longitudeSpan = 20;
    int latitudeSpan = 30;
    int zoomLevel = 1;
    private ShadowMapController shadowMapController;
    private ZoomButtonsController zoomButtonsController;
    private MapView realMapView;
    private Projection projection;
    private boolean useBuiltInZoomMapControls;
    private boolean mouseDownOnMe = false;
    private Point lastTouchEventPoint;
    private GeoPoint mouseDownCenter;
    private boolean preLoadWasCalled;
    private boolean canCoverCenter = true;

    public ShadowMapView(MapView mapView) {
        this.realMapView = mapView;
        this.zoomButtonsController = new ZoomButtonsController((View)mapView);
    }

    public void __constructor__(Context context, String title) {
        super.__constructor__(context);
    }

    public static int toE6(double d) {
        return (int)(d * 1000000.0);
    }

    public static double fromE6(int i) {
        return (double)i / 1000000.0;
    }

    @Implementation
    public void setSatellite(boolean satelliteOn) {
        this.satelliteOn = satelliteOn;
    }

    @Implementation
    public boolean isSatellite() {
        return this.satelliteOn;
    }

    @Implementation
    public boolean canCoverCenter() {
        return this.canCoverCenter;
    }

    @Implementation
    public MapController getController() {
        if (this.mapController == null) {
            try {
                this.mapController = Robolectric.newInstanceOf(MapController.class);
                this.shadowMapController = RobolectricForMaps.shadowOf(this.mapController);
                this.shadowMapController.setShadowMapView(this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.mapController;
    }

    @Implementation
    public ZoomButtonsController getZoomButtonsController() {
        return this.zoomButtonsController;
    }

    @Implementation
    public void setBuiltInZoomControls(boolean useBuiltInZoomMapControls) {
        this.useBuiltInZoomMapControls = useBuiltInZoomMapControls;
    }

    @Implementation
    public Projection getProjection() {
        if (this.projection == null) {
            this.projection = new Projection(){

                public Point toPixels(GeoPoint geoPoint, Point point) {
                    if (point == null) {
                        point = new Point();
                    }
                    point.y = ShadowMapView.this.scaleDegree(geoPoint.getLatitudeE6(), ShadowMapView.this.bottom, ShadowMapView.this.top, ShadowMapView.this.mapCenter.getLatitudeE6(), ShadowMapView.this.latitudeSpan);
                    point.x = ShadowMapView.this.scaleDegree(geoPoint.getLongitudeE6(), ShadowMapView.this.left, ShadowMapView.this.right, ShadowMapView.this.mapCenter.getLongitudeE6(), ShadowMapView.this.longitudeSpan);
                    return point;
                }

                public GeoPoint fromPixels(int x, int y) {
                    int lat = ShadowMapView.this.scalePixel(y, ShadowMapView.this.bottom, -ShadowMapView.this.realMapView.getHeight(), ShadowMapView.this.mapCenter.getLatitudeE6(), ShadowMapView.this.latitudeSpan);
                    int lng = ShadowMapView.this.scalePixel(x, ShadowMapView.this.left, ShadowMapView.this.realMapView.getWidth(), ShadowMapView.this.mapCenter.getLongitudeE6(), ShadowMapView.this.longitudeSpan);
                    return new GeoPoint(lat, lng);
                }

                public float metersToEquatorPixels(float v) {
                    return 0.0f;
                }
            };
        }
        return this.projection;
    }

    private int scalePixel(int pixel, int minPixel, int maxPixel, int centerDegree, int spanDegrees) {
        int offsetPixels = pixel - minPixel;
        double ratio = (double)offsetPixels / (double)maxPixel;
        int minDegrees = centerDegree - spanDegrees / 2;
        return (int)((double)minDegrees + (double)spanDegrees * ratio);
    }

    private int scaleDegree(int degree, int minPixel, int maxPixel, int centerDegree, int spanDegrees) {
        int minDegree = centerDegree - spanDegrees / 2;
        int offsetDegrees = degree - minDegree;
        double ratio = (double)offsetDegrees / (double)spanDegrees;
        int spanPixels = maxPixel - minPixel;
        return (int)((double)minPixel + (double)spanPixels * ratio);
    }

    @Implementation
    public List<Overlay> getOverlays() {
        return this.overlays;
    }

    @Implementation
    public GeoPoint getMapCenter() {
        return this.mapCenter;
    }

    @Implementation
    public int getLatitudeSpan() {
        return this.latitudeSpan;
    }

    @Implementation
    public int getLongitudeSpan() {
        return this.longitudeSpan;
    }

    @Implementation
    public int getZoomLevel() {
        return this.zoomLevel;
    }

    @Override
    @Implementation
    public boolean dispatchTouchEvent(MotionEvent event) {
        for (Overlay overlay : this.overlays) {
            if (!overlay.onTouchEvent(event, this.realMapView)) continue;
            return true;
        }
        GeoPoint mouseGeoPoint = this.getProjection().fromPixels((int)event.getX(), (int)event.getY());
        int diffX = 0;
        int diffY = 0;
        if (this.mouseDownOnMe) {
            diffX = (int)event.getX() - this.lastTouchEventPoint.x;
            diffY = (int)event.getY() - this.lastTouchEventPoint.y;
        }
        switch (event.getAction()) {
            case 0: {
                this.mouseDownOnMe = true;
                this.mouseDownCenter = this.getMapCenter();
                break;
            }
            case 2: {
                if (!this.mouseDownOnMe) break;
                this.moveByPixels(-diffX, -diffY);
                break;
            }
            case 1: {
                if (!this.mouseDownOnMe) break;
                this.moveByPixels(-diffX, -diffY);
                this.mouseDownOnMe = false;
                break;
            }
            case 3: {
                this.getController().setCenter(this.mouseDownCenter);
                this.mouseDownOnMe = false;
            }
        }
        this.lastTouchEventPoint = new Point((int)event.getX(), (int)event.getY());
        return super.dispatchTouchEvent(event);
    }

    @Implementation
    public void preLoad() {
        this.preLoadWasCalled = true;
    }

    private void moveByPixels(int x, int y) {
        Point center = this.getProjection().toPixels(this.mapCenter, null);
        center.offset(x, y);
        this.mapCenter = this.getProjection().fromPixels(center.x, center.y);
    }

    public boolean getUseBuiltInZoomMapControls() {
        return this.useBuiltInZoomMapControls;
    }

    public boolean preLoadWasCalled() {
        return this.preLoadWasCalled;
    }

    public void setLatitudeSpan(int latitudeSpan) {
        this.latitudeSpan = latitudeSpan;
    }

    public void setLongitudeSpan(int longitudeSpan) {
        this.longitudeSpan = longitudeSpan;
    }

    public void setCanCoverCenter(boolean canCoverCenter) {
        this.canCoverCenter = canCoverCenter;
    }
}

