/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.graphics.Matrix;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;

@Implements(value=Matrix.class)
public class ShadowMatrix {
    private float scaleX = 1.0f;
    private float transX;
    private float scaleY = 1.0f;
    private float transY;

    public void __constructor__(Matrix src) {
        this.set(src);
    }

    @Implementation
    public void set(Matrix src) {
        this.transX = Robolectric.shadowOf((Matrix)src).transX;
        this.scaleX = Robolectric.shadowOf((Matrix)src).scaleX;
        this.transY = Robolectric.shadowOf((Matrix)src).transY;
        this.scaleY = Robolectric.shadowOf((Matrix)src).scaleY;
    }

    @Implementation
    public void setTranslate(float dx, float dy) {
        this.transX = dx;
        this.transY = dy;
    }

    @Implementation
    public void postTranslate(float dx, float dy) {
        this.transX += dx;
        this.transY += dy;
    }

    public float getTransX() {
        return this.transX;
    }

    public float getTransY() {
        return this.transY;
    }

    @Implementation
    public boolean postScale(float sx, float sy, float px, float py) {
        this.scaleX *= sx;
        this.scaleY *= sy;
        return true;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }
}

