/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.database.CursorIndexOutOfBoundsException;
import android.database.MatrixCursor;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.shadows.ShadowAbstractCursor;
import java.util.ArrayList;
import java.util.List;

@Implements(value=MatrixCursor.class)
public class ShadowMatrixCursor
extends ShadowAbstractCursor {
    private List<Object[]> data = new ArrayList<Object[]>();

    public void __constructor__(String[] columns) {
        this.__constructor__(columns, 0);
    }

    public void __constructor__(String[] columns, int initialCapacity) {
        this.columnNameArray = columns;
    }

    @Implementation
    public void addRow(Object[] data) {
        ++this.rowCount;
        this.data.add(data);
    }

    @Implementation
    public String getString(int column) {
        return (String)this.get(column);
    }

    @Implementation
    public long getLong(int column) {
        return (Long)this.get(column);
    }

    @Implementation
    public short getShort(int column) {
        return (Short)this.get(column);
    }

    @Implementation
    public int getInt(int column) {
        return (Integer)this.get(column);
    }

    @Implementation
    public float getFloat(int column) {
        return ((Float)this.get(column)).floatValue();
    }

    @Implementation
    public double getDouble(int column) {
        return (Double)this.get(column);
    }

    @Implementation
    public boolean isNull(int column) {
        return this.get(column) == null;
    }

    private Object get(int column) {
        if (column < 0 || column >= this.columnNameArray.length) {
            throw new CursorIndexOutOfBoundsException(null);
        }
        if (this.currentRowNumber < 0) {
            throw new CursorIndexOutOfBoundsException("Before first row.");
        }
        if (this.currentRowNumber >= this.rowCount) {
            throw new CursorIndexOutOfBoundsException("After last row.");
        }
        return this.data.get(this.currentRowNumber)[column];
    }
}

