/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;

@Implements(value=MediaPlayer.class)
public class ShadowMediaPlayer {
    @RealObject
    private MediaPlayer player;
    private boolean playing;
    private boolean prepared;
    private int currentPosition;
    private Uri sourceUri;
    private int sourceResId;
    private MediaPlayer.OnCompletionListener completionListener;
    private MediaPlayer.OnPreparedListener preparedListener;

    @Implementation
    public static MediaPlayer create(Context context, int resId) {
        MediaPlayer mp = new MediaPlayer();
        Robolectric.shadowOf((MediaPlayer)mp).sourceResId = resId;
        try {
            mp.prepare();
        }
        catch (Exception e) {
            return null;
        }
        return mp;
    }

    @Implementation
    public static MediaPlayer create(Context context, Uri uri) {
        MediaPlayer mp = new MediaPlayer();
        try {
            mp.setDataSource(context, uri);
            mp.prepare();
        }
        catch (Exception e) {
            return null;
        }
        return mp;
    }

    public void __constructor__() {
        this.playing = true;
    }

    @Implementation
    public void setDataSource(Context context, Uri uri) {
        this.sourceUri = uri;
    }

    @Implementation
    public void setOnCompletionListener(MediaPlayer.OnCompletionListener listener) {
        this.completionListener = listener;
    }

    @Implementation
    public void setOnPreparedListener(MediaPlayer.OnPreparedListener listener) {
        this.preparedListener = listener;
    }

    @Implementation
    public boolean isPlaying() {
        return this.playing;
    }

    @Implementation
    public void prepare() {
        this.prepared = true;
        this.invokePreparedListener();
    }

    @Implementation
    public void prepareAsync() {
        this.prepared = true;
    }

    @Implementation
    public void start() {
        this.playing = true;
    }

    @Implementation
    public void pause() {
        this.playing = false;
    }

    @Implementation
    public void release() {
        this.playing = false;
        this.prepared = false;
    }

    @Implementation
    public void reset() {
        this.playing = false;
        this.prepared = false;
    }

    @Implementation
    public void stop() {
        this.playing = false;
    }

    @Implementation
    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public void setCurrentPosition(int position) {
        this.currentPosition = position;
    }

    public Uri getSourceUri() {
        return this.sourceUri;
    }

    public int getSourceResId() {
        return this.sourceResId;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public MediaPlayer.OnCompletionListener getOnCompletionListener() {
        return this.completionListener;
    }

    public MediaPlayer.OnPreparedListener getOnPreparedListener() {
        return this.preparedListener;
    }

    public void invokePreparedListener() {
        if (this.preparedListener == null) {
            return;
        }
        this.preparedListener.onPrepared(this.player);
    }

    public void invokeCompletionListener() {
        if (this.completionListener == null) {
            return;
        }
        this.completionListener.onCompletion(this.player);
    }
}

