/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.view.MotionEvent;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import java.lang.reflect.Constructor;

@Implements(value=MotionEvent.class)
public class ShadowMotionEvent {
    @RealObject
    private MotionEvent realObject;
    private int action;
    private float[] x = new float[2];
    private float[] y = new float[2];
    private int pointerCount = 1;
    private long downTime;
    private long eventTime;
    private int[] pointerIds = new int[2];
    private int pointerIndex;

    @Implementation
    public static MotionEvent obtain(long downTime, long eventTime, int action, float x, float y, int metaState) {
        try {
            Constructor constructor = MotionEvent.class.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            MotionEvent motionEvent = (MotionEvent)constructor.newInstance(new Object[0]);
            ShadowMotionEvent shadowMotionEvent = (ShadowMotionEvent)Robolectric.shadowOf_(motionEvent);
            shadowMotionEvent.x[0] = x;
            shadowMotionEvent.y[0] = y;
            shadowMotionEvent.action = action;
            shadowMotionEvent.downTime = downTime;
            shadowMotionEvent.eventTime = eventTime;
            return motionEvent;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation
    public static MotionEvent obtain(MotionEvent motionEvent) {
        return ShadowMotionEvent.obtain(motionEvent.getDownTime(), motionEvent.getEventTime(), motionEvent.getAction(), motionEvent.getX(), motionEvent.getY(), motionEvent.getMetaState());
    }

    @Implementation
    public int getAction() {
        return this.action | this.pointerIndex << 8;
    }

    @Implementation
    public float getRawX() {
        return this.getX();
    }

    @Implementation
    public float getRawY() {
        return this.getY();
    }

    @Implementation
    public final float getX() {
        return this.getX(0);
    }

    @Implementation
    public final float getY() {
        return this.getY(0);
    }

    @Implementation
    public final float getX(int pointerIndex) {
        return this.x[pointerIndex];
    }

    @Implementation
    public final float getY(int pointerIndex) {
        return this.y[pointerIndex];
    }

    @Implementation
    public final int getPointerCount() {
        return this.pointerCount;
    }

    @Implementation
    public final long getEventTime() {
        return this.eventTime;
    }

    @Implementation
    public final long getDownTime() {
        return this.downTime;
    }

    @Implementation
    public final int getPointerId(int index) {
        return this.pointerIds[index];
    }

    @Implementation
    public final int findPointerIndex(int id) {
        for (int i = 0; i < this.pointerIds.length; ++i) {
            int pointerId = this.pointerIds[i];
            if (pointerId != id) continue;
            return i;
        }
        return -1;
    }

    @Implementation
    public final int getActionMasked() {
        return this.action;
    }

    @Implementation
    public final int getActionIndex() {
        return this.pointerIndex;
    }

    @Implementation
    public final float getPressure(int pointerIndex) {
        return 1.0f;
    }

    @Implementation
    public final void setLocation(float x, float y) {
        this.x[0] = x;
        this.y[0] = y;
    }

    public MotionEvent setPointer2(float x, float y) {
        this.x[1] = x;
        this.y[1] = y;
        this.pointerCount = 2;
        return this.realObject;
    }

    public void setPointerIndex(int pointerIndex) {
        this.pointerIndex = pointerIndex;
    }

    public void setPointerIds(int index0PointerId, int index1PointerId) {
        this.pointerIds[0] = index0PointerId;
        this.pointerIds[1] = index1PointerId;
    }
}

