/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.net.NetworkInfo;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;

@Implements(value=NetworkInfo.class)
public class ShadowNetworkInfo {
    private boolean isAvailable = true;
    private boolean isConnected = true;
    private int connectionType = 0;
    private NetworkInfo.DetailedState detailedState;

    public static NetworkInfo newInstance() {
        return ShadowNetworkInfo.newInstance(null);
    }

    public static NetworkInfo newInstance(NetworkInfo.DetailedState detailedState) {
        NetworkInfo networkInfo = Robolectric.newInstanceOf(NetworkInfo.class);
        Robolectric.shadowOf(networkInfo).setDetailedState(detailedState);
        return networkInfo;
    }

    @Implementation
    public boolean isConnected() {
        return this.isConnected;
    }

    @Implementation
    public boolean isConnectedOrConnecting() {
        return this.isConnected;
    }

    @Implementation
    public NetworkInfo.State getState() {
        return this.isConnected ? NetworkInfo.State.CONNECTED : NetworkInfo.State.DISCONNECTED;
    }

    @Implementation
    public NetworkInfo.DetailedState getDetailedState() {
        return this.detailedState;
    }

    @Implementation
    public int getType() {
        return this.connectionType;
    }

    public void setAvailableStatus(boolean isAvailable) {
        this.isAvailable = isAvailable;
    }

    @Implementation
    public boolean isAvailable() {
        return this.isAvailable;
    }

    public void setConnectionStatus(boolean isConnected) {
        this.isConnected = isConnected;
    }

    public void setConnectionType(int connectionType) {
        this.connectionType = connectionType;
    }

    public void setDetailedState(NetworkInfo.DetailedState detailedState) {
        this.detailedState = detailedState;
    }
}

