/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.app.Notification;
import android.app.NotificationManager;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Implements(value=NotificationManager.class)
public class ShadowNotificationManager {
    private Map<Integer, Notification> notifications = new HashMap<Integer, Notification>();
    private Map<String, Integer> idForTag = new HashMap<String, Integer>();

    @Implementation
    public void notify(int id, Notification notification) {
        this.notify(null, id, notification);
    }

    @Implementation
    public void notify(String tag, int id, Notification notification) {
        if (tag != null) {
            this.idForTag.put(tag, id);
        }
        this.notifications.put(id, notification);
    }

    @Implementation
    public void cancel(int id) {
        this.cancel(null, id);
    }

    @Implementation
    public void cancel(String tag, int id) {
        Integer tagId = this.idForTag.remove(tag);
        if (this.notifications.containsKey(id)) {
            this.notifications.remove(id);
        } else {
            this.notifications.remove(tagId);
        }
    }

    @Implementation
    public void cancelAll() {
        this.notifications.clear();
        this.idForTag.clear();
    }

    public int size() {
        return this.notifications.size();
    }

    public Notification getNotification(int id) {
        return this.notifications.get(id);
    }

    public Notification getNotification(String tag) {
        Integer id = this.idForTag.get(tag);
        return this.notifications.get(id);
    }

    public List<Notification> getAllNotifications() {
        return new ArrayList<Notification>(this.notifications.values());
    }
}

