/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.util.Pair;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import java.lang.reflect.Field;

@Implements(value=Pair.class)
public class ShadowPair {
    @RealObject
    private Pair realPair;

    public void __constructor__(Object first, Object second) {
        ShadowPair.setFields(this.realPair, first, second);
    }

    @Implementation
    public static <F, S> Pair<F, S> create(F f, S s) {
        return new Pair(f, s);
    }

    @Implementation
    public int hashCode() {
        return this.realPair.first.hashCode() + this.realPair.second.hashCode();
    }

    @Implementation
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)o;
        return this.realPair.first.equals(other.first) && this.realPair.second.equals(other.second);
    }

    private static void setFields(Pair p, Object first, Object second) {
        try {
            Field f = Pair.class.getDeclaredField("first");
            f.setAccessible(true);
            f.set(p, first);
            Field s = Pair.class.getDeclaredField("second");
            s.setAccessible(true);
            s.set(p, second);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

