/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.TestIntentSender;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;

@Implements(value=PendingIntent.class)
public class ShadowPendingIntent {
    private Intent savedIntent;
    private Context savedContext;
    private boolean isActivityIntent;
    private boolean isBroadcastIntent;
    private boolean isServiceIntent;
    private int requestCode;

    @Implementation
    public static PendingIntent getActivity(Context context, int requestCode, Intent intent, int flags) {
        return ShadowPendingIntent.create(context, intent, true, false, false, requestCode);
    }

    @Implementation
    public static PendingIntent getBroadcast(Context context, int requestCode, Intent intent, int flags) {
        return ShadowPendingIntent.create(context, intent, false, true, false, requestCode);
    }

    @Implementation
    public static PendingIntent getService(Context context, int requestCode, Intent intent, int flags) {
        return ShadowPendingIntent.create(context, intent, false, false, true, requestCode);
    }

    @Implementation
    public void send() throws PendingIntent.CanceledException {
        this.send(this.savedContext, 0, this.savedIntent);
    }

    @Implementation
    public void send(Context context, int code, Intent intent) throws PendingIntent.CanceledException {
        this.savedIntent.fillIn(intent, 0);
        if (this.isActivityIntent) {
            context.startActivity(this.savedIntent);
        } else if (this.isBroadcastIntent) {
            context.sendBroadcast(this.savedIntent);
        } else if (this.isServiceIntent) {
            context.startService(this.savedIntent);
        }
    }

    @Implementation
    public IntentSender getIntentSender() {
        TestIntentSender testIntentSender = new TestIntentSender();
        testIntentSender.intent = this.savedIntent;
        return testIntentSender;
    }

    public boolean isActivityIntent() {
        return this.isActivityIntent;
    }

    public boolean isBroadcastIntent() {
        return this.isBroadcastIntent;
    }

    public boolean isServiceIntent() {
        return this.isServiceIntent;
    }

    public Context getSavedContext() {
        return this.savedContext;
    }

    public Intent getSavedIntent() {
        return this.savedIntent;
    }

    public int getRequestCode() {
        return this.requestCode;
    }

    private static PendingIntent create(Context context, Intent intent, boolean isActivity, boolean isBroadcast, boolean isService, int requestCode) {
        PendingIntent pendingIntent = Robolectric.newInstanceOf(PendingIntent.class);
        ShadowPendingIntent shadowPendingIntent = Robolectric.shadowOf(pendingIntent);
        shadowPendingIntent.savedIntent = intent;
        shadowPendingIntent.isActivityIntent = isActivity;
        shadowPendingIntent.isBroadcastIntent = isBroadcast;
        shadowPendingIntent.isServiceIntent = isService;
        shadowPendingIntent.savedContext = context;
        shadowPendingIntent.requestCode = requestCode;
        return pendingIntent;
    }
}

