/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.content.Context;
import android.content.Intent;
import android.preference.Preference;
import android.util.AttributeSet;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;

@Implements(value=Preference.class)
public class ShadowPreference {
    @RealObject
    private Preference realPreference;
    protected Context context;
    protected AttributeSet attrs;
    protected int defStyle;
    protected String key;
    protected CharSequence title;
    protected CharSequence summary;
    protected Object defaultValue;
    protected int order;
    protected boolean enabled = true;
    protected String dependencyKey;
    protected boolean persistent = false;
    protected int persistedInt;
    protected Object callChangeListenerValue = null;
    protected Preference.OnPreferenceClickListener onClickListener;
    private Intent intent;

    public void __constructor__(Context context) {
        this.__constructor__(context, null, 0);
    }

    public void __constructor__(Context context, AttributeSet attributeSet) {
        this.__constructor__(context, attributeSet, 0);
    }

    public void __constructor__(Context context, AttributeSet attributeSet, int defStyle) {
        this.context = context;
        this.attrs = attributeSet;
        this.defStyle = defStyle;
        if (attributeSet != null) {
            this.key = attributeSet.getAttributeValue("android", "key");
        }
    }

    @Implementation
    public Context getContext() {
        return this.context;
    }

    public AttributeSet getAttrs() {
        return this.attrs;
    }

    public int getDefStyle() {
        return this.defStyle;
    }

    @Implementation
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Implementation
    public boolean isEnabled() {
        return this.enabled;
    }

    @Implementation
    public boolean shouldPersist() {
        return this.persistent;
    }

    @Implementation
    public boolean isPersistent() {
        return this.persistent;
    }

    @Implementation
    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    @Implementation
    public int getPersistedInt(int defaultReturnValue) {
        return this.persistent ? this.persistedInt : defaultReturnValue;
    }

    @Implementation
    public boolean persistInt(int value) {
        this.persistedInt = value;
        return this.persistent;
    }

    @Implementation
    public boolean callChangeListener(Object newValue) {
        this.callChangeListenerValue = newValue;
        return true;
    }

    public Object getCallChangeListenerValue() {
        return this.callChangeListenerValue;
    }

    @Implementation
    public void setSummary(int summaryResId) {
        this.summary = this.context.getResources().getText(summaryResId);
    }

    @Implementation
    public void setSummary(CharSequence summary) {
        this.summary = summary;
    }

    @Implementation
    public CharSequence getSummary() {
        return this.summary;
    }

    @Implementation
    public void setTitle(int titleResId) {
        this.title = this.context.getResources().getText(titleResId);
    }

    @Implementation
    public void setTitle(CharSequence title) {
        this.title = title;
    }

    @Implementation
    public CharSequence getTitle() {
        return this.title;
    }

    @Implementation
    public void setKey(String key) {
        this.key = key;
    }

    @Implementation
    public String getKey() {
        return this.key;
    }

    @Implementation
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Implementation
    public int getOrder() {
        return this.order;
    }

    @Implementation
    public void setOrder(int order) {
        this.order = order;
    }

    @Implementation
    public void setOnPreferenceClickListener(Preference.OnPreferenceClickListener onPreferenceClickListener) {
        this.onClickListener = onPreferenceClickListener;
    }

    @Implementation
    public Preference.OnPreferenceClickListener getOnPreferenceClickListener() {
        return this.onClickListener;
    }

    public boolean click() {
        return this.onClickListener.onPreferenceClick(this.realPreference);
    }

    @Implementation
    public void setIntent(Intent i) {
        this.intent = i;
    }

    @Implementation
    public Intent getIntent() {
        return this.intent;
    }

    @Implementation
    public void setDependency(String dependencyKey) {
        this.dependencyKey = dependencyKey;
    }

    @Implementation
    public String getDependency() {
        return this.dependencyKey;
    }
}

