/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.preference.Preference;
import android.preference.PreferenceGroup;
import android.text.TextUtils;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import com.xtremelabs.robolectric.shadows.ShadowPreference;
import java.util.ArrayList;

@Implements(value=PreferenceGroup.class)
public class ShadowPreferenceGroup
extends ShadowPreference {
    @RealObject
    private PreferenceGroup realPreferenceGroup;
    private ArrayList<Preference> preferenceList = new ArrayList();

    @Implementation
    public void addItemFromInflater(Preference preference) {
        this.addPreference(preference);
    }

    @Implementation
    public boolean addPreference(Preference preference) {
        if (this.preferenceList.contains(preference)) {
            return true;
        }
        this.preferenceList.add(preference);
        return true;
    }

    @Implementation
    public Preference getPreference(int index) {
        return this.preferenceList.get(index);
    }

    @Implementation
    public int getPreferenceCount() {
        return this.preferenceList.size();
    }

    @Implementation
    public boolean removePreference(Preference preference) {
        return this.preferenceList.remove(preference);
    }

    @Implementation
    public void removeAll() {
        this.preferenceList.clear();
    }

    @Implementation
    public Preference findPreference(CharSequence key) {
        if (TextUtils.equals((CharSequence)this.getKey(), (CharSequence)key)) {
            return this.realPreferenceGroup;
        }
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            Preference returnedPreference;
            Preference preference = this.getPreference(i);
            String curKey = preference.getKey();
            if (curKey != null && curKey.equals(key)) {
                return preference;
            }
            if (!(preference instanceof PreferenceGroup) || (returnedPreference = ((PreferenceGroup)preference).findPreference(key)) == null) continue;
            return returnedPreference;
        }
        return null;
    }

    @Override
    @Implementation
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            this.getPreference(i).setEnabled(enabled);
        }
    }
}

