/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.widget.RadioGroup;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import com.xtremelabs.robolectric.shadows.ShadowLinearLayout;

@Implements(value=RadioGroup.class)
public class ShadowRadioGroup
extends ShadowLinearLayout {
    @RealObject
    protected RadioGroup realGroup;
    private int checkedRadioButtonId = -1;
    private RadioGroup.OnCheckedChangeListener onCheckedChangeListener;

    @Implementation
    public int getCheckedRadioButtonId() {
        return this.checkedRadioButtonId;
    }

    @Implementation
    public void check(int id) {
        this.checkedRadioButtonId = id;
        this.notifyListener();
    }

    @Implementation
    public void clearCheck() {
        this.notifyListener();
        this.checkedRadioButtonId = -1;
        this.notifyListener();
    }

    private void notifyListener() {
        if (this.onCheckedChangeListener != null) {
            this.onCheckedChangeListener.onCheckedChanged(this.realGroup, this.checkedRadioButtonId);
        }
    }

    @Implementation
    public void setOnCheckedChangeListener(RadioGroup.OnCheckedChangeListener listener) {
        this.onCheckedChangeListener = listener;
    }
}

