/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.widget.RatingBar;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import com.xtremelabs.robolectric.shadows.ShadowAbsSeekBar;

@Implements(value=RatingBar.class)
public class ShadowRatingBar
extends ShadowAbsSeekBar {
    @RealObject
    private RatingBar realRatingBar;
    private int mNumStars = 5;
    private RatingBar.OnRatingBarChangeListener listener;

    @Override
    public void applyAttributes() {
        super.applyAttributes();
        this.setIsIndicator(this.attributeSet.getAttributeBooleanValue("android", "isIndicator", false));
        int numStars = this.attributeSet.getAttributeIntValue("android", "numStars", this.mNumStars);
        float rating = this.attributeSet.getAttributeFloatValue("android", "rating", -1.0f);
        float stepSize = this.attributeSet.getAttributeFloatValue("android", "stepSize", -1.0f);
        if (numStars > 0 && numStars != this.mNumStars) {
            this.setNumStars(numStars);
        }
        if (stepSize >= 0.0f) {
            this.setStepSize(stepSize);
        } else {
            this.setStepSize(0.5f);
        }
        if (rating >= 0.0f) {
            this.setRating(rating);
        }
    }

    @Implementation
    public void setNumStars(int numStars) {
        if (numStars <= 0) {
            return;
        }
        this.mNumStars = numStars;
    }

    @Implementation
    public int getNumStars() {
        return this.mNumStars;
    }

    @Implementation
    public void setRating(float rating) {
        this.setProgress(Math.round(rating * this.getProgressPerStar()));
    }

    @Implementation
    public float getRating() {
        return (float)this.getProgress() / this.getProgressPerStar();
    }

    @Implementation
    public void setIsIndicator(boolean isIndicator) {
        this.mIsUserSeekable = !isIndicator;
        this.setFocusable(!isIndicator);
    }

    @Implementation
    public boolean isIndicator() {
        return !this.mIsUserSeekable;
    }

    @Implementation
    public void setStepSize(float stepSize) {
        if (stepSize <= 0.0f) {
            return;
        }
        float newMax = (float)this.mNumStars / stepSize;
        int newProgress = (int)(newMax / (float)this.getMax() * (float)this.getProgress());
        this.setMax((int)newMax);
        this.setProgress(newProgress);
    }

    @Implementation
    public float getStepSize() {
        return (float)this.getNumStars() / (float)this.getMax();
    }

    private float getProgressPerStar() {
        if (this.mNumStars > 0) {
            return 1.0f * (float)this.getMax() / (float)this.mNumStars;
        }
        return 1.0f;
    }

    @Override
    @Implementation
    public void setProgress(int progress) {
        super.setProgress(progress);
        if (this.listener != null) {
            this.listener.onRatingChanged(this.realRatingBar, this.getRating(), true);
        }
    }

    @Implementation
    public void setOnRatingBarChangeListener(RatingBar.OnRatingBarChangeListener listener) {
        this.listener = listener;
    }

    @Implementation
    public RatingBar.OnRatingBarChangeListener getOnRatingBarChangeListener() {
        return this.listener;
    }
}

