/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.graphics.Rect;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;

@Implements(value=Rect.class)
public class ShadowRect {
    @RealObject
    Rect realRect;

    public void __constructor__(int left, int top, int right, int bottom) {
        this.realRect.left = left;
        this.realRect.top = top;
        this.realRect.right = right;
        this.realRect.bottom = bottom;
    }

    public void __constructor__(Rect otherRect) {
        this.realRect.left = otherRect.left;
        this.realRect.top = otherRect.top;
        this.realRect.right = otherRect.right;
        this.realRect.bottom = otherRect.bottom;
    }

    @Implementation
    public void set(Rect rect) {
        this.set(rect.left, rect.top, rect.right, rect.bottom);
    }

    @Implementation
    public void set(int left, int top, int right, int bottom) {
        this.realRect.left = left;
        this.realRect.top = top;
        this.realRect.right = right;
        this.realRect.bottom = bottom;
    }

    @Implementation
    public int width() {
        return this.realRect.right - this.realRect.left;
    }

    @Implementation
    public int height() {
        return this.realRect.bottom - this.realRect.top;
    }

    @Implementation
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Object o = Robolectric.shadowOf_(obj);
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Rect r = (Rect)obj;
        return this.realRect.left == r.left && this.realRect.top == r.top && this.realRect.right == r.right && this.realRect.bottom == r.bottom;
    }

    @Implementation
    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("Rect(");
        sb.append(this.realRect.left);
        sb.append(", ");
        sb.append(this.realRect.top);
        sb.append(" - ");
        sb.append(this.realRect.right);
        sb.append(", ");
        sb.append(this.realRect.bottom);
        sb.append(")");
        return sb.toString();
    }

    @Implementation
    public boolean contains(int x, int y) {
        return x > this.realRect.left && x < this.realRect.right && y >= this.realRect.top && y <= this.realRect.bottom;
    }

    @Implementation
    public boolean contains(Rect r) {
        return this.equals(r) || this.contains(r.left, r.top) && this.contains(r.right, r.top) && this.contains(r.left, r.bottom) && this.contains(r.right, r.bottom);
    }

    @Implementation
    public static boolean intersects(Rect a, Rect b) {
        return a.left < b.right && b.left < a.right && a.top < b.bottom && b.top < a.bottom;
    }

    @Implementation
    public boolean intersect(Rect r) {
        return ShadowRect.intersects(this.realRect, r);
    }

    @Implementation
    public boolean intersect(int left, int top, int right, int bottom) {
        return this.intersect(new Rect(left, top, right, bottom));
    }

    @Implementation
    public void offset(int dx, int dy) {
        this.realRect.left += dx;
        this.realRect.right += dx;
        this.realRect.top += dy;
        this.realRect.bottom += dy;
    }
}

