/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.Display;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import com.xtremelabs.robolectric.res.ResourceExtractor;
import com.xtremelabs.robolectric.res.ResourceLoader;
import com.xtremelabs.robolectric.shadows.ShadowAssetManager;
import java.io.InputStream;
import java.util.Locale;

@Implements(value=Resources.class)
public class ShadowResources {
    private float density = 1.0f;
    Configuration configuration = null;
    private DisplayMetrics displayMetrics;
    private Display display;
    @RealObject
    Resources realResources;
    private ResourceLoader resourceLoader;

    static Resources bind(Resources resources, ResourceLoader resourceLoader) {
        ShadowResources shadowResources = Robolectric.shadowOf(resources);
        if (shadowResources.resourceLoader != null) {
            throw new RuntimeException("ResourceLoader already set!");
        }
        shadowResources.resourceLoader = resourceLoader;
        return resources;
    }

    @Implementation
    public int getIdentifier(String name, String defType, String defPackage) {
        Integer index = 0;
        ResourceExtractor resourceExtractor = this.resourceLoader.getResourceExtractor();
        index = resourceExtractor.getResourceId(defType + "/" + name);
        if (index == null) {
            return 0;
        }
        return index;
    }

    @Implementation
    public int getColor(int id) throws Resources.NotFoundException {
        return this.resourceLoader.getColorValue(id);
    }

    @Implementation
    public Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new Configuration();
            this.configuration.setToDefaults();
        }
        if (this.configuration.locale == null) {
            this.configuration.locale = Locale.getDefault();
        }
        return this.configuration;
    }

    @Implementation
    public String getString(int id) throws Resources.NotFoundException {
        return this.resourceLoader.getStringValue(id);
    }

    @Implementation
    public String getString(int id, Object ... formatArgs) throws Resources.NotFoundException {
        String raw = this.getString(id);
        return String.format(Locale.ENGLISH, raw, formatArgs);
    }

    @Implementation
    public String getQuantityString(int id, int quantity, Object ... formatArgs) throws Resources.NotFoundException {
        String raw = this.getQuantityString(id, quantity);
        return String.format(Locale.ENGLISH, raw, formatArgs);
    }

    @Implementation
    public String getQuantityString(int id, int quantity) throws Resources.NotFoundException {
        return this.resourceLoader.getPluralStringValue(id, quantity);
    }

    @Implementation
    public InputStream openRawResource(int id) throws Resources.NotFoundException {
        return this.resourceLoader.getRawValue(id);
    }

    @Implementation
    public String[] getStringArray(int id) throws Resources.NotFoundException {
        String[] arrayValue = this.resourceLoader.getStringArrayValue(id);
        if (arrayValue == null) {
            throw new Resources.NotFoundException();
        }
        return arrayValue;
    }

    @Implementation
    public CharSequence[] getTextArray(int id) throws Resources.NotFoundException {
        return this.getStringArray(id);
    }

    @Implementation
    public CharSequence getText(int id) throws Resources.NotFoundException {
        return this.getString(id);
    }

    public void setDensity(float density) {
        this.density = density;
    }

    public void setDisplay(Display display) {
        this.display = display;
        this.displayMetrics = null;
    }

    @Implementation
    public DisplayMetrics getDisplayMetrics() {
        if (this.displayMetrics == null) {
            if (this.display == null) {
                this.display = Robolectric.newInstanceOf(Display.class);
            }
            this.displayMetrics = new DisplayMetrics();
            this.display.getMetrics(this.displayMetrics);
        }
        this.displayMetrics.density = this.density;
        return this.displayMetrics;
    }

    @Implementation
    public Drawable getDrawable(int drawableResourceId) throws Resources.NotFoundException {
        ResourceLoader resLoader = Robolectric.shadowOf(Robolectric.application).getResourceLoader();
        Drawable xmlDrawable = resLoader.getXmlDrawable(drawableResourceId);
        if (xmlDrawable != null) {
            return xmlDrawable;
        }
        Drawable animDrawable = resLoader.getAnimDrawable(drawableResourceId);
        if (animDrawable != null) {
            return animDrawable;
        }
        Drawable colorDrawable = resLoader.getColorDrawable(drawableResourceId);
        if (colorDrawable != null) {
            return colorDrawable;
        }
        return new BitmapDrawable(BitmapFactory.decodeResource((Resources)this.realResources, (int)drawableResourceId));
    }

    @Implementation
    public float getDimension(int id) throws Resources.NotFoundException {
        if (this.resourceLoader.dimensions.containsKey(id)) {
            return this.resourceLoader.dimensions.get(id).intValue();
        }
        return this.resourceLoader.getDimenValue(id);
    }

    @Implementation
    public int getInteger(int id) throws Resources.NotFoundException {
        return this.resourceLoader.getIntegerValue(id);
    }

    @Implementation
    public int getDimensionPixelSize(int id) throws Resources.NotFoundException {
        return (int)this.getDimension(id);
    }

    @Implementation
    public int getDimensionPixelOffset(int id) throws Resources.NotFoundException {
        return (int)this.getDimension(id);
    }

    @Implementation
    public AssetManager getAssets() {
        return ShadowAssetManager.bind(Robolectric.newInstanceOf(AssetManager.class), this.resourceLoader);
    }

    @Implementation
    public final Resources.Theme newTheme() {
        return Robolectric.newInstanceOf(Resources.Theme.class);
    }

    public void setDimension(int id, int value) {
        this.resourceLoader.dimensions.put(id, value);
    }

    @Implements(value=Resources.Theme.class)
    public static class ShadowTheme {
        @Implementation
        public TypedArray obtainStyledAttributes(int[] attrs) {
            return this.obtainStyledAttributes(0, attrs);
        }

        @Implementation
        public TypedArray obtainStyledAttributes(int resid, int[] attrs) throws Resources.NotFoundException {
            return this.obtainStyledAttributes(null, attrs, 0, 0);
        }

        @Implementation
        public TypedArray obtainStyledAttributes(AttributeSet set, int[] attrs, int defStyleAttr, int defStyleRes) {
            return Robolectric.newInstanceOf(TypedArray.class);
        }
    }
}

