/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.database.sqlite.SQLiteCursor;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.shadows.ShadowAbstractCursor;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

@Implements(value=SQLiteCursor.class)
public class ShadowSQLiteCursor
extends ShadowAbstractCursor {
    private ResultSet resultSet;

    private void cacheColumnNames(ResultSet rs) {
        try {
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            this.columnNameArray = new String[columnCount];
            for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
                String cName = metaData.getColumnName(columnIndex).toLowerCase();
                this.columnNames.put(cName, columnIndex - 1);
                this.columnNameArray[columnIndex - 1] = cName;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("SQL exception in cacheColumnNames", e);
        }
    }

    private Integer getColIndex(String columnName) {
        if (columnName == null) {
            return -1;
        }
        Integer i = (Integer)this.columnNames.get(columnName.toLowerCase());
        if (i == null) {
            return -1;
        }
        return i;
    }

    @Override
    @Implementation
    public int getColumnIndex(String columnName) {
        return this.getColIndex(columnName);
    }

    @Override
    @Implementation
    public int getColumnIndexOrThrow(String columnName) {
        Integer columnIndex = this.getColIndex(columnName);
        if (columnIndex == -1) {
            throw new IllegalArgumentException("Column index does not exist");
        }
        return columnIndex;
    }

    @Override
    @Implementation
    public final boolean moveToLast() {
        return super.moveToLast();
    }

    @Override
    @Implementation
    public final boolean moveToFirst() {
        return super.moveToFirst();
    }

    @Override
    @Implementation
    public boolean moveToNext() {
        return super.moveToNext();
    }

    @Override
    @Implementation
    public boolean moveToPrevious() {
        return super.moveToPrevious();
    }

    @Override
    @Implementation
    public boolean moveToPosition(int pos) {
        return super.moveToPosition(pos);
    }

    @Implementation
    public byte[] getBlob(int columnIndex) {
        this.checkPosition();
        return (byte[])this.currentRow.get(this.getColumnNames()[columnIndex]);
    }

    @Implementation
    public String getString(int columnIndex) {
        this.checkPosition();
        Object value = this.currentRow.get(this.getColumnNames()[columnIndex]);
        if (value instanceof Clob) {
            try {
                return ((Clob)value).getSubString(1L, (int)((Clob)value).length());
            }
            catch (SQLException x) {
                throw new RuntimeException(x);
            }
        }
        return (String)value;
    }

    @Implementation
    public short getShort(int columnIndex) {
        this.checkPosition();
        Object o = this.currentRow.get(this.getColumnNames()[columnIndex]);
        if (o == null) {
            return 0;
        }
        return new Short(o.toString());
    }

    @Implementation
    public int getInt(int columnIndex) {
        this.checkPosition();
        Object o = this.currentRow.get(this.getColumnNames()[columnIndex]);
        if (o == null) {
            return 0;
        }
        return new Integer(o.toString());
    }

    @Implementation
    public long getLong(int columnIndex) {
        this.checkPosition();
        Object o = this.currentRow.get(this.getColumnNames()[columnIndex]);
        if (o == null) {
            return 0L;
        }
        return new Long(o.toString());
    }

    @Implementation
    public float getFloat(int columnIndex) {
        this.checkPosition();
        Object o = this.currentRow.get(this.getColumnNames()[columnIndex]);
        if (o == null) {
            return 0.0f;
        }
        return new Float(o.toString()).floatValue();
    }

    @Implementation
    public double getDouble(int columnIndex) {
        this.checkPosition();
        Object o = this.currentRow.get(this.getColumnNames()[columnIndex]);
        if (o == null) {
            return 0.0;
        }
        return new Double(o.toString());
    }

    private void checkPosition() {
        if (-1 == this.currentRowNumber || this.getCount() == this.currentRowNumber) {
            throw new IndexOutOfBoundsException(this.currentRowNumber + " " + this.getCount());
        }
    }

    @Implementation
    public void close() {
        if (this.resultSet == null) {
            return;
        }
        try {
            this.resultSet.close();
            this.resultSet = null;
            this.rows = null;
            this.currentRow = null;
        }
        catch (SQLException e) {
            throw new RuntimeException("SQL exception in close", e);
        }
    }

    @Implementation
    public boolean isClosed() {
        return this.resultSet == null;
    }

    @Implementation
    public boolean isNull(int columnIndex) {
        Object o = this.currentRow.get(this.getColumnNames()[columnIndex]);
        return o == null;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public ResultSet getResultSetMetaData() {
        return this.resultSet;
    }

    private Map<String, Object> fillRowValues(ResultSet rs) throws SQLException {
        HashMap<String, Object> row = new HashMap<String, Object>();
        for (String s : this.getColumnNames()) {
            row.put(s, rs.getObject(s));
        }
        return row;
    }

    private void fillRows(String sql, Connection connection) throws SQLException {
        Statement statement = connection.createStatement(1003, 1007);
        ResultSet rs = statement.executeQuery(sql);
        int count = 0;
        if (rs.next()) {
            do {
                Map<String, Object> row = this.fillRowValues(rs);
                this.rows.put(count, row);
                ++count;
            } while (rs.next());
        } else {
            rs.close();
        }
        this.rowCount = count;
    }

    public void setResultSet(ResultSet result, String sql) {
        this.resultSet = result;
        this.rowCount = 0;
        if (this.resultSet != null) {
            this.cacheColumnNames(this.resultSet);
            try {
                this.fillRows(sql, result.getStatement().getConnection());
            }
            catch (SQLException e) {
                throw new RuntimeException("SQL exception in setResultSet", e);
            }
        }
    }
}

