/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.SQLException;
import android.database.sqlite.SQLiteClosable;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseCorruptException;
import android.database.sqlite.SQLiteProgram;
import android.database.sqlite.SQLiteQueryBuilder;
import android.database.sqlite.SQLiteStatement;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import com.xtremelabs.robolectric.util.DatabaseConfig;
import com.xtremelabs.robolectric.util.SQLite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Iterator;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;

@Implements(value=SQLiteDatabase.class)
public class ShadowSQLiteDatabase {
    @RealObject
    SQLiteDatabase realSQLiteDatabase;
    private static Connection connection;
    private final ReentrantLock mLock = new ReentrantLock(true);
    private boolean mLockingEnabled = true;
    private WeakHashMap<SQLiteClosable, Object> mPrograms;
    private boolean transactionSuccess = false;
    private boolean throwOnInsert;

    @Implementation
    public void setLockingEnabled(boolean lockingEnabled) {
        this.mLockingEnabled = lockingEnabled;
    }

    public void lock() {
        if (!this.mLockingEnabled) {
            return;
        }
        this.mLock.lock();
    }

    public void unlock() {
        if (!this.mLockingEnabled) {
            return;
        }
        this.mLock.unlock();
    }

    public void setThrowOnInsert(boolean throwOnInsert) {
        this.throwOnInsert = throwOnInsert;
    }

    @Implementation
    public static SQLiteDatabase openDatabase(String path, SQLiteDatabase.CursorFactory factory, int flags) {
        connection = DatabaseConfig.getMemoryConnection();
        return Robolectric.newInstanceOf(SQLiteDatabase.class);
    }

    @Implementation
    public long insert(String table, String nullColumnHack, ContentValues values) {
        return this.insertWithOnConflict(table, nullColumnHack, values, 0);
    }

    @Implementation
    public long insertOrThrow(String table, String nullColumnHack, ContentValues values) {
        if (this.throwOnInsert) {
            throw new SQLException();
        }
        return this.insertWithOnConflict(table, nullColumnHack, values, 0);
    }

    @Implementation
    public long replace(String table, String nullColumnHack, ContentValues values) {
        return this.insertWithOnConflict(table, nullColumnHack, values, 5);
    }

    @Implementation
    public long insertWithOnConflict(String table, String nullColumnHack, ContentValues initialValues, int conflictAlgorithm) {
        try {
            SQLite.SQLStringAndBindings sqlInsertString = SQLite.buildInsertString(table, initialValues, conflictAlgorithm);
            PreparedStatement insert = connection.prepareStatement(sqlInsertString.sql, 1);
            Iterator<Object> columns = sqlInsertString.columnValues.iterator();
            int i = 1;
            long result = -1L;
            while (columns.hasNext()) {
                insert.setObject(i++, columns.next());
            }
            insert.executeUpdate();
            ResultSet resultSet = insert.getGeneratedKeys();
            if (resultSet.next()) {
                result = resultSet.getLong(1);
            }
            resultSet.close();
            return result;
        }
        catch (java.sql.SQLException e) {
            return -1L;
        }
    }

    @Implementation
    public Cursor query(boolean distinct, String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        ResultSet resultSet;
        String where = selection;
        if (selection != null && selectionArgs != null) {
            where = SQLite.buildWhereClause(selection, selectionArgs);
        }
        String sql = SQLiteQueryBuilder.buildQueryString((boolean)distinct, (String)table, (String[])columns, (String)where, (String)groupBy, (String)having, (String)orderBy, (String)limit);
        try {
            Statement statement = connection.createStatement(DatabaseConfig.getResultSetType(), 1007);
            resultSet = statement.executeQuery(sql);
        }
        catch (java.sql.SQLException e) {
            throw new RuntimeException("SQL exception in query", e);
        }
        SQLiteCursor cursor = new SQLiteCursor(null, null, null, null);
        Robolectric.shadowOf(cursor).setResultSet(resultSet, sql);
        return cursor;
    }

    @Implementation
    public Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy) {
        return this.query(false, table, columns, selection, selectionArgs, groupBy, having, orderBy, null);
    }

    @Implementation
    public Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        return this.query(false, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
    }

    @Implementation
    public int update(String table, ContentValues values, String whereClause, String[] whereArgs) {
        SQLite.SQLStringAndBindings sqlUpdateString = SQLite.buildUpdateString(table, values, whereClause, whereArgs);
        try {
            PreparedStatement statement = connection.prepareStatement(sqlUpdateString.sql);
            Iterator<Object> columns = sqlUpdateString.columnValues.iterator();
            int i = 1;
            while (columns.hasNext()) {
                statement.setObject(i++, columns.next());
            }
            return statement.executeUpdate();
        }
        catch (java.sql.SQLException e) {
            throw new RuntimeException("SQL exception in update", e);
        }
    }

    @Implementation
    public int delete(String table, String whereClause, String[] whereArgs) {
        String sql = SQLite.buildDeleteString(table, whereClause, whereArgs);
        try {
            return connection.prepareStatement(sql).executeUpdate();
        }
        catch (java.sql.SQLException e) {
            throw new RuntimeException("SQL exception in delete", e);
        }
    }

    @Implementation
    public void execSQL(String sql) throws SQLException {
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        try {
            String scrubbedSql = DatabaseConfig.getScrubSQL(sql);
            connection.createStatement().execute(scrubbedSql);
        }
        catch (java.sql.SQLException e) {
            SQLException ase = new SQLException();
            ase.initCause((Throwable)e);
            throw ase;
        }
    }

    @Implementation
    public void execSQL(String sql, Object[] bindArgs) throws java.sql.SQLException {
        if (bindArgs == null) {
            throw new IllegalArgumentException("Empty bindArgs");
        }
        String scrubbedSql = DatabaseConfig.getScrubSQL(sql);
        SQLiteStatement statement = null;
        try {
            statement = this.compileStatement(scrubbedSql);
            if (bindArgs != null) {
                int numArgs = bindArgs.length;
                for (int i = 0; i < numArgs; ++i) {
                    DatabaseUtils.bindObjectToProgram((SQLiteProgram)statement, (int)(i + 1), (Object)bindArgs[i]);
                }
            }
            statement.execute();
        }
        catch (SQLiteDatabaseCorruptException e) {
            throw e;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    @Implementation
    public Cursor rawQuery(String sql, String[] selectionArgs) {
        ResultSet resultSet;
        String sqlBody = sql;
        if (sql != null) {
            sqlBody = SQLite.buildWhereClause(sql, selectionArgs);
        }
        try {
            SQLiteStatement stmt = this.compileStatement(sql);
            int numArgs = selectionArgs == null ? 0 : selectionArgs.length;
            for (int i = 0; i < numArgs; ++i) {
                stmt.bindString(i + 1, selectionArgs[i]);
            }
            resultSet = Robolectric.shadowOf(stmt).getStatement().executeQuery();
        }
        catch (java.sql.SQLException e) {
            throw new RuntimeException("SQL exception in query", e);
        }
        SQLiteCursor cursor = new SQLiteCursor(null, null, null, null);
        Robolectric.shadowOf(cursor).setResultSet(resultSet, sqlBody);
        return cursor;
    }

    @Implementation
    public boolean isOpen() {
        return connection != null;
    }

    @Implementation
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        try {
            connection.close();
            connection = null;
        }
        catch (java.sql.SQLException e) {
            throw new RuntimeException("SQL exception in close", e);
        }
    }

    @Implementation
    public void beginTransaction() {
        try {
            connection.setAutoCommit(false);
        }
        catch (java.sql.SQLException e) {
            throw new RuntimeException("SQL exception in beginTransaction", e);
        }
    }

    @Implementation
    public void setTransactionSuccessful() {
        if (!this.isOpen()) {
            throw new IllegalStateException("connection is not opened");
        }
        if (this.transactionSuccess) {
            throw new IllegalStateException("transaction already successfully");
        }
        this.transactionSuccess = true;
    }

    @Implementation
    public void endTransaction() {
        try {
            if (this.transactionSuccess) {
                this.transactionSuccess = false;
                connection.commit();
            } else {
                connection.rollback();
            }
            connection.setAutoCommit(true);
        }
        catch (java.sql.SQLException e) {
            throw new RuntimeException("SQL exception in beginTransaction", e);
        }
    }

    public boolean isTransactionSuccess() {
        return this.transactionSuccess;
    }

    public Connection getConnection() {
        return connection;
    }

    @Implementation
    public SQLiteStatement compileStatement(String sql) throws java.sql.SQLException {
        this.lock();
        String scrubbedSql = DatabaseConfig.getScrubSQL(sql);
        try {
            SQLiteStatement stmt = Robolectric.newInstanceOf(SQLiteStatement.class);
            Robolectric.shadowOf(stmt).init(this.realSQLiteDatabase, scrubbedSql);
            SQLiteStatement sQLiteStatement = stmt;
            return sQLiteStatement;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSQLiteClosable(SQLiteClosable closable) {
        this.lock();
        try {
            this.mPrograms.put(closable, null);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSQLiteClosable(SQLiteClosable closable) {
        this.lock();
        try {
            this.mPrograms.remove(closable);
        }
        finally {
            this.unlock();
        }
    }
}

